/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.http.IriDecoderHelper;
import org.apache.cxf.binding.http.URIMapper;
import org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIParameterInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = Logger.getLogger(URIParameterInterceptor.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(URIParameterInterceptor.class);

    public URIParameterInterceptor() {
        this.setPhase("unmarshal");
        this.addBefore(XMLMessageInInterceptor.class.getName());
    }

    public void handleMessage(Message message) {
        String path = (String)message.get((Object)"relative.path");
        String method = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
        String contentType = (String)message.get((Object)"Content-Type");
        LOG.info("URIParameterInterceptor handle message on path [" + path + "] with content-type [" + contentType + "]");
        BindingOperationInfo op = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        URIMapper mapper = (URIMapper)((Service)message.getExchange().get(Service.class)).get((Object)URIMapper.class.getName());
        String location = mapper.getLocation(op);
        List parts = op.getOperationInfo().getInput().getMessageParts();
        if (parts.size() == 0) {
            message.setContent(Object.class, (Object)Collections.EMPTY_LIST);
            return;
        }
        if (parts.size() > 1) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("SINGLE_PART_REQUIRED", BUNDLE, new Object[0]));
        }
        message.getInterceptorChain().add((Interceptor)new XMLMessageInInterceptor());
        MessagePartInfo part = (MessagePartInfo)parts.get(0);
        List<IriDecoderHelper.Param> params = null;
        if ("application/x-www-form-urlencoded.".equals(contentType)) {
            params = IriDecoderHelper.decode(path, location, (InputStream)message.getContent(InputStream.class));
        } else if ("application/xml".equals(contentType)) {
            params = IriDecoderHelper.decodeIri(path, location);
        } else if ("text/xml".equals(contentType)) {
            params = IriDecoderHelper.decodeIri(path, location);
        } else if (!"multipart/form-data".equals(contentType)) {
            params = IriDecoderHelper.decodeIri(path, location);
        }
        this.mergeParams(message, path, method, part, params);
    }

    private void mergeParams(Message message, String path, String method, MessagePartInfo part, List<IriDecoderHelper.Param> params) {
        Document doc;
        if ("POST".equals(method) || "PUT".equals(method)) {
            XMLInputFactory inputFactory = StaxInInterceptor.getXMLInputFactory((Message)message);
            try {
                XMLStreamReader reader = inputFactory.createXMLStreamReader((InputStream)message.getContent(InputStream.class));
                doc = StaxUtils.read((XMLStreamReader)reader);
            }
            catch (XMLStreamException e) {
                throw new Fault((Throwable)e);
            }
            doc = IriDecoderHelper.interopolateParams(doc, (XmlSchemaElement)part.getXmlSchema(), params);
        } else {
            doc = IriDecoderHelper.buildDocument((XmlSchemaElement)part.getXmlSchema(), params);
        }
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((Source)new DOMSource(doc));
        try {
            reader.next();
        }
        catch (XMLStreamException e) {
            throw new Fault((Throwable)e);
        }
        message.setContent(XMLStreamReader.class, (Object)reader);
    }
}

