/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.ServiceModelHttpConfigurationProvider;
import org.apache.cxf.transport.http.destination.HTTPDestinationConfigBean;
import org.apache.cxf.transports.http.configuration.HTTPServerPolicy;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHTTPDestination
extends HTTPDestinationConfigBean
implements Destination {
    static final Logger LOG = LogUtils.getL7dLogger(AbstractHTTPDestination.class);
    private static final long serialVersionUID = 1L;
    protected final Bus bus;
    protected final ConduitInitiator conduitInitiator;
    protected final EndpointInfo endpointInfo;
    protected final EndpointReferenceType reference;
    protected String name;
    protected URL nurl;

    public AbstractHTTPDestination(Bus b, ConduitInitiator ci, EndpointInfo ei) throws IOException {
        this.bus = b;
        this.conduitInitiator = ci;
        this.endpointInfo = ei;
        this.init();
        this.nurl = new URL(this.getAddressValue());
        this.name = this.nurl.getPath();
        this.reference = new EndpointReferenceType();
        AttributedURIType address = new AttributedURIType();
        address.setValue(this.getAddressValue());
        this.reference.setAddress(address);
    }

    public String getBeanName() {
        String beanName = null;
        if (this.endpointInfo.getName() != null) {
            beanName = this.endpointInfo.getName().toString() + ".http-destination";
        }
        return beanName;
    }

    public EndpointReferenceType getAddress() {
        return this.reference;
    }

    protected void setHeaders(Message message) {
        List authorizationLines;
        String credentials;
        String authType;
        HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
        this.copyRequestHeaders(message, requestHeaders);
        message.put((Object)Message.PROTOCOL_HEADERS, requestHeaders);
        if (requestHeaders.containsKey("Authorization") && "Basic".equals(authType = (credentials = (String)(authorizationLines = (List)requestHeaders.get("Authorization")).get(0)).split(" ")[0])) {
            String authEncoded = credentials.split(" ")[1];
            try {
                String authDecoded = new String(Base64Utility.decode((String)authEncoded));
                String[] authInfo = authDecoded.split(":");
                String username = authInfo[0];
                String password = authInfo[1];
                AuthorizationPolicy policy = new AuthorizationPolicy();
                policy.setUserName(username);
                policy.setPassword(password);
                message.put(AuthorizationPolicy.class, (Object)policy);
            }
            catch (Base64Exception ex) {
                // empty catch block
            }
        }
    }

    protected void updateResponseHeaders(Message message) {
        HashMap responseHeaders = (HashMap)message.get((Object)Message.PROTOCOL_HEADERS);
        if (responseHeaders == null) {
            responseHeaders = new HashMap();
            message.put((Object)Message.PROTOCOL_HEADERS, responseHeaders);
        }
        this.setPolicies(responseHeaders);
    }

    protected boolean isOneWay(Message message) {
        return message.getExchange() != null && message.getExchange().isOneWay();
    }

    protected abstract void copyRequestHeaders(Message var1, Map<String, List<String>> var2);

    protected final String getAddressValue() {
        return StringUtils.addDefaultPortIfMissing((String)this.endpointInfo.getAddress());
    }

    private void init() {
        ArrayList<ServiceModelHttpConfigurationProvider> providers;
        if (!this.isSetServer()) {
            this.setServer(new HTTPServerPolicy());
        }
        if (null == (providers = this.getOverwriteProviders())) {
            providers = new ArrayList<ServiceModelHttpConfigurationProvider>();
        }
        ServiceModelHttpConfigurationProvider p = new ServiceModelHttpConfigurationProvider(this.endpointInfo, true);
        providers.add(p);
        this.setOverwriteProviders(providers);
    }

    void setPolicies(Map<String, List<String>> headers) {
        HTTPServerPolicy policy = this.getServer();
        if (policy.isSetCacheControl()) {
            headers.put("Cache-Control", Arrays.asList(policy.getCacheControl().value()));
        }
        if (policy.isSetContentLocation()) {
            headers.put("Content-Location", Arrays.asList(policy.getContentLocation()));
        }
        if (policy.isSetContentEncoding()) {
            headers.put("Content-Encoding", Arrays.asList(policy.getContentEncoding()));
        }
        if (policy.isSetContentType()) {
            headers.put("Content-Type", Arrays.asList(policy.getContentType()));
        }
        if (policy.isSetServerType()) {
            headers.put("Server", Arrays.asList(policy.getServerType()));
        }
        if (policy.isSetHonorKeepAlive() && !policy.isHonorKeepAlive()) {
            headers.put("Connection", Arrays.asList("close"));
        }
    }

    boolean contextMatchOnExact() {
        return "exact".equals(this.getContextMatchStrategy());
    }
}

