/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.security.SSLClientPolicy;
import org.apache.cxf.transport.http.URLConnectionFactory;
import org.apache.cxf.transport.https.SSLSocketFactoryWrapper;
import org.apache.cxf.transport.https.SSLUtils;

public final class HttpsURLConnectionFactory
implements URLConnectionFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogUtils.getL7dLogger(HttpsURLConnectionFactory.class);
    private static final String[] UNSUPPORTED = new String[]{"SessionCaching", "SessionCacheKey", "MaxChainLength", "CertValidator", "ProxyHost", "ProxyPort"};
    SSLClientPolicy sslPolicy;

    public HttpsURLConnectionFactory(SSLClientPolicy policy) {
        this.sslPolicy = policy;
    }

    public URLConnection createConnection(Proxy proxy, URL url) throws IOException {
        URLConnection connection;
        URLConnection uRLConnection = connection = proxy != null ? url.openConnection(proxy) : url.openConnection();
        if (connection instanceof HttpsURLConnection) {
            this.decorate((HttpsURLConnection)connection);
        }
        return connection;
    }

    protected void decorate(HttpsURLConnection secureConnection) {
        String keyStoreLocation = SSLUtils.getKeystore(this.sslPolicy.getKeystore(), LOG);
        String keyStoreType = SSLUtils.getKeystoreType(this.sslPolicy.getKeystoreType(), LOG);
        String keyStorePassword = SSLUtils.getKeystorePassword(this.sslPolicy.getKeystorePassword(), LOG);
        String keyPassword = SSLUtils.getKeyPassword(this.sslPolicy.getKeyPassword(), LOG);
        String keyStoreMgrFactoryAlgorithm = SSLUtils.getKeystoreAlgorithm(this.sslPolicy.getKeystoreAlgorithm(), LOG);
        String trustStoreMgrFactoryAlgorithm = SSLUtils.getTrustStoreAlgorithm(this.sslPolicy.getTrustStoreAlgorithm(), LOG);
        String[] cipherSuites = SSLUtils.getCiphersuites(this.sslPolicy.getCiphersuites(), LOG);
        String trustStoreLocation = SSLUtils.getTrustStore(this.sslPolicy.getTrustStore(), LOG);
        String trustStoreType = SSLUtils.getTrustStoreType(this.sslPolicy.getTrustStoreType(), LOG);
        String secureSocketProtocol = SSLUtils.getSecureSocketProtocol(this.sslPolicy.getSecureSocketProtocol(), LOG);
        try {
            SSLContext sslctx = SSLContext.getInstance(secureSocketProtocol);
            boolean pkcs12 = keyStoreType.equalsIgnoreCase("PKCS12");
            sslctx.init(SSLUtils.getKeyStoreManagers(keyStoreLocation, keyStoreType, keyStorePassword, keyPassword, keyStoreMgrFactoryAlgorithm, secureSocketProtocol, LOG), SSLUtils.getTrustStoreManagers(pkcs12, trustStoreType, trustStoreLocation, trustStoreMgrFactoryAlgorithm, LOG), null);
            secureConnection.setSSLSocketFactory(new SSLSocketFactoryWrapper(sslctx.getSocketFactory(), cipherSuites));
        }
        catch (Exception e) {
            LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"SSL_CONTEXT_INIT_FAILURE", (Throwable)e, (Object[])new Object[0]);
        }
        SSLUtils.logUnSupportedPolicies(this.sslPolicy, true, UNSUPPORTED, LOG);
    }

    protected void addLogHandler(Handler handler) {
        LOG.addHandler(handler);
    }

    protected String[] getUnSupported() {
        return UNSUPPORTED;
    }
}

