/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageContainer
extends AbstractPropertiesHolder {
    private OperationInfo operation;
    private QName mName;
    private Map<QName, MessagePartInfo> messageParts = new LinkedHashMap<QName, MessagePartInfo>(4);

    AbstractMessageContainer(OperationInfo op, QName nm) {
        this.operation = op;
        this.mName = nm;
    }

    public QName getName() {
        return this.mName;
    }

    public OperationInfo getOperation() {
        return this.operation;
    }

    public MessagePartInfo addMessagePart(QName name) {
        if (name == null) {
            throw new IllegalArgumentException("Invalid name [" + name + "]");
        }
        MessagePartInfo part = new MessagePartInfo(name, this);
        this.addMessagePart(part);
        return part;
    }

    public MessagePartInfo addMessagePart(String name) {
        return this.addMessagePart(new QName(this.getOperation().getInterface().getService().getTargetNamespace(), name));
    }

    public void addMessagePart(MessagePartInfo part) {
        this.messageParts.put(part.getName(), part);
    }

    public int getMessagePartIndex(MessagePartInfo part) {
        int idx = 0;
        for (MessagePartInfo p : this.messageParts.values()) {
            if (part == p) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public MessagePartInfo getMessagePartByIndex(int i) {
        int idx = 0;
        for (MessagePartInfo p : this.messageParts.values()) {
            if (idx == i) {
                return p;
            }
            ++idx;
        }
        return null;
    }

    public void removeMessagePart(QName name) {
        MessagePartInfo messagePart = this.getMessagePart(name);
        if (messagePart != null) {
            this.messageParts.remove(name);
        }
    }

    public MessagePartInfo getMessagePart(QName name) {
        return this.messageParts.get(name);
    }

    public List<MessagePartInfo> getMessageParts() {
        return Collections.unmodifiableList(new ArrayList<MessagePartInfo>(this.messageParts.values()));
    }

    public int size() {
        return this.messageParts.size();
    }
}

