/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.wsdl.Port;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.extensions.soap.SoapAddress;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;

public class SoapDestinationFactory
extends AbstractTransportFactory
implements DestinationFactory,
WSDLEndpointFactory {
    public static final String TRANSPORT_ID = "http://schemas.xmlsoap.org/soap/";
    private Bus bus;

    public Destination getDestination(EndpointInfo ei) throws IOException {
        SoapBindingInfo binding = (SoapBindingInfo)ei.getBinding();
        try {
            DestinationFactory destinationFactory = ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).getDestinationFactory(binding.getTransportURI());
            return destinationFactory.getDestination(ei);
        }
        catch (BusException e) {
            throw new RuntimeException("Could not find destination factory for transport " + binding.getTransportURI());
        }
    }

    public void createPortExtensors(EndpointInfo ei, Service service) {
        SoapBindingInfo bi = (SoapBindingInfo)ei.getBinding();
        if (bi.getSoapVersion() instanceof Soap11) {
            this.createSoap11Extensors(ei, bi);
        }
    }

    private void createSoap11Extensors(EndpointInfo ei, SoapBindingInfo bi) {
        SOAPAddressImpl address = new SOAPAddressImpl();
        address.setLocationURI(ei.getAddress());
        ei.addExtensor((Object)address);
        SOAPBindingImpl sbind = new SOAPBindingImpl();
        sbind.setStyle(bi.getStyle());
        sbind.setTransportURI(bi.getTransportURI());
        bi.addExtensor(sbind);
        for (BindingOperationInfo b : bi.getOperations()) {
            SOAPBodyImpl body;
            SoapOperationInfo soi = (SoapOperationInfo)b.getExtensor(SoapOperationInfo.class);
            SOAPOperationImpl op = new SOAPOperationImpl();
            op.setSoapActionURI(soi.getAction());
            op.setStyle(soi.getStyle());
            b.addExtensor((Object)op);
            if (b.getInput() != null) {
                body = new SOAPBodyImpl();
                body.setUse("literal");
                b.getInput().addExtensor((Object)body);
            }
            if (b.getOutput() == null) continue;
            body = new SOAPBodyImpl();
            body.setUse("literal");
            b.getOutput().addExtensor((Object)body);
        }
    }

    public EndpointInfo createEndpointInfo(ServiceInfo serviceInfo, BindingInfo b, Port port) {
        List ees = port.getExtensibilityElements();
        for (Object extensor : ees) {
            if (!SOAPBindingUtil.isSOAPAddress(extensor)) continue;
            SoapAddress sa = SOAPBindingUtil.getSoapAddress(extensor);
            SoapBindingInfo sbi = (SoapBindingInfo)b;
            EndpointInfo info = new EndpointInfo(serviceInfo, sbi.getTransportURI());
            info.setAddress(sa.getLocationURI());
            return info;
        }
        return null;
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setBus(Bus bus) {
        this.bus = bus;
    }
}

