/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapInPostInterceptor
extends AbstractInDatabindingInterceptor {
    public SoapInPostInterceptor() {
        this.setPhase("unmarshal");
        this.addAfter(BareInInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        Exchange exchange = message.getExchange();
        List parameters = CastUtils.cast((List)((List)message.getContent(List.class)));
        Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
        Service service = ep.getService();
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        if (message.get(Element.class) != null) {
            parameters.addAll(this.abstractParamsFromHeader((Element)message.get(Element.class), ep, message));
        }
        if (bop == null) {
            for (OperationInfo op : service.getServiceInfo().getInterface().getOperations()) {
                Method method = (Method)op.getExtensor(Method.class);
                if (!this.isMethodMatch(parameters, method)) continue;
                bop = ep.getEndpointInfo().getBinding().getOperation(op);
                exchange.put(BindingOperationInfo.class, (Object)bop);
                exchange.setOneWay(op.isOneWay());
                break;
            }
            if (bop == null) {
                throw new Fault((Throwable)new RuntimeException("Can not find target operation"));
            }
        }
        message.setContent(List.class, (Object)parameters);
    }

    private boolean isMethodMatch(List params, Method method) {
        Class<?>[] cls = method.getParameterTypes();
        Type[] types = method.getGenericParameterTypes();
        if (params.size() != cls.length) {
            return false;
        }
        for (int i = 0; i < cls.length; ++i) {
            Class<?> valueClass = cls[i];
            if (cls[i].getName().equals("javax.xml.ws.Holder")) {
                valueClass = ((ParameterizedType)types[i]).getRawType().getClass();
            }
            if (params.get(i).getClass().isAssignableFrom(valueClass)) continue;
            return false;
        }
        return true;
    }

    private List<Object> abstractParamsFromHeader(Element headerElement, Endpoint ep, Message message) {
        ArrayList<Object> paramInHeader = new ArrayList<Object>();
        ArrayList<Element> elemInHeader = new ArrayList<Element>();
        for (BindingOperationInfo bop : ep.getEndpointInfo().getBinding().getOperations()) {
            BindingMessageInfo bmi;
            BindingMessageInfo bindingMessageInfo = bmi = this.isRequestor(message) ? bop.getOutput() : bop.getInput();
            if (bmi == null) {
                return paramInHeader;
            }
            List headers = bmi.getExtensors(SoapHeaderInfo.class);
            if (headers == null) {
                return paramInHeader;
            }
            for (SoapHeaderInfo header : headers) {
                MessagePartInfo mpi = header.getPart();
                NodeList nodeList = headerElement.getChildNodes();
                if (nodeList == null) continue;
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element param;
                    if (!nodeList.item(i).getNamespaceURI().equals(mpi.getElementQName().getNamespaceURI()) || !nodeList.item(i).getLocalName().equals(mpi.getElementQName().getLocalPart()) || elemInHeader.contains(param = (Element)nodeList.item(i))) continue;
                    elemInHeader.add(param);
                }
            }
        }
        for (Element element : elemInHeader) {
            paramInHeader.add(this.getNodeDataReader(message).read((Object)element));
        }
        return paramInHeader;
    }
}

