/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingProviderImpl
implements BindingProvider {
    protected AtomicReference<Map<String, Object>> requestContext = new AtomicReference();
    protected Map<String, Object> responseContext;
    private final Binding binding;

    public BindingProviderImpl() {
        this.binding = null;
    }

    public BindingProviderImpl(Binding b) {
        this.binding = b;
    }

    public Map<String, Object> getRequestContext() {
        if (null == this.requestContext.get()) {
            this.requestContext.compareAndSet(null, new ConcurrentHashMap(4));
        }
        return this.requestContext.get();
    }

    public Map<String, Object> getResponseContext() {
        if (this.responseContext == null) {
            this.responseContext = new HashMap<String, Object>();
        }
        return this.responseContext;
    }

    public Binding getBinding() {
        return this.binding;
    }

    protected void populateResponseContext(MessageContext ctx) {
        Iterator iter = ctx.keySet().iterator();
        Map<String, Object> respCtx = this.getResponseContext();
        while (iter.hasNext()) {
            String obj = (String)iter.next();
            if (MessageContext.Scope.APPLICATION.compareTo((Enum)ctx.getScope(obj)) != 0) continue;
            respCtx.put(obj, ctx.get((Object)obj));
        }
    }
}

