/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.AsyncCallbackFuture;
import org.apache.cxf.jaxws.AsyncResponse;
import org.apache.cxf.jaxws.BindingProviderImpl;
import org.apache.cxf.jaxws.JAXWSAsyncCallable;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.service.factory.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndpointInvocationHandler
extends BindingProviderImpl
implements InvocationHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(EndpointInvocationHandler.class);
    private Endpoint endpoint;
    private Client client;

    public EndpointInvocationHandler(Client c, Binding b) {
        super(b);
        this.endpoint = c.getEndpoint();
        this.client = c;
        this.setupEndpointAddressContext();
    }

    private void setupEndpointAddressContext() {
        if (null != this.endpoint && null != this.endpoint.getEndpointInfo().getAddress()) {
            Map<String, Object> requestContext = this.getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", this.endpoint.getEndpointInfo().getAddress());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodDispatcher dispatcher = (MethodDispatcher)this.endpoint.getService().get((Object)MethodDispatcher.class.getName());
        BindingOperationInfo oi = dispatcher.getBindingOperation(method, this.endpoint);
        if (oi == null) {
            if (method.getDeclaringClass().equals(BindingProvider.class) || method.getDeclaringClass().equals(BindingProviderImpl.class) || method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, new Object[0]);
            }
            Message msg = new Message("NO_OPERATION_INFO", LOG, new Object[]{method.getName()});
            throw new WebServiceException(msg.toString());
        }
        Object[] params = args;
        if (null == params) {
            params = new Object[]{};
        }
        Object[] paramsWithOutHolder = this.handleHolder(params);
        Map<String, Object> requestContext = this.getRequestContext();
        Map<String, Object> responseContext = this.getResponseContext();
        HashMap<String, Object> context = new HashMap<String, Object>();
        ContextPropertiesMapping.mapRequestfromJaxws2Cxf(requestContext);
        context.put("RequestContext", requestContext);
        context.put("ResponseContext", responseContext);
        requestContext.put(Method.class.getName(), method);
        boolean isAsync = method.getName().endsWith("Async");
        Object result = null;
        result = isAsync ? this.invokeAsync(method, oi, params, paramsWithOutHolder, context) : this.invokeSync(method, oi, params, paramsWithOutHolder, context);
        ContextPropertiesMapping.mapResponsefromCxf2Jaxws(responseContext);
        return result;
    }

    Object invokeSync(Method method, BindingOperationInfo oi, Object[] params, Object[] paramsWithOutHolder, Map<String, Object> context) throws Exception {
        Object[] rawRet = this.client.invoke(oi, paramsWithOutHolder, context);
        if (rawRet != null && rawRet.length != 0) {
            ArrayList<Object> retList = new ArrayList<Object>();
            this.handleHolderReturn(params, method, rawRet, retList);
            Object[] obj = retList.toArray();
            return obj == null || obj.length == 0 ? null : obj[0];
        }
        return null;
    }

    Client getClient() {
        return this.client;
    }

    private Object invokeAsync(Method method, BindingOperationInfo oi, Object[] params, Object[] paramsWithOutHolder, Map<String, Object> context) {
        FutureTask<Object> f = new FutureTask<Object>(new JAXWSAsyncCallable(this, method, oi, params, paramsWithOutHolder, context));
        this.endpoint.getService().setExecutor(new Executor(){

            public void execute(Runnable r) {
                new Thread(r).start();
            }
        });
        this.endpoint.getService().getExecutor().execute(f);
        AsyncResponse<Object> r = new AsyncResponse<Object>(f, Object.class);
        if (params.length > 0 && params[params.length - 1] instanceof AsyncHandler) {
            AsyncCallbackFuture callback = new AsyncCallbackFuture(r, (AsyncHandler)params[params.length - 1]);
            this.endpoint.getService().getExecutor().execute(callback);
            return callback;
        }
        return r;
    }

    private Object[] handleHolder(Object[] params) {
        Object[] ret = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            ret[i] = params[i] instanceof Holder ? ((Holder)params[i]).value : params[i];
        }
        return ret;
    }

    private void handleHolderReturn(Object[] params, Method method, Object[] rawRet, List<Object> retList) {
        int i;
        int idx = 0;
        if (method == null) {
            return;
        }
        if (!method.getReturnType().getName().equals("void")) {
            retList.add(rawRet[0]);
            ++idx;
        }
        int holderStartIndex = 0;
        Type[] para = method.getGenericParameterTypes();
        for (i = 0; i < para.length; ++i) {
            if (para[i] instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)para[i];
                if (((Class)paramType.getRawType()).getName().equals("javax.xml.ws.Holder")) break;
                ++holderStartIndex;
                continue;
            }
            ++holderStartIndex;
        }
        i = idx;
        while (i < rawRet.length) {
            try {
                ((Holder)params[holderStartIndex]).getClass().getField("value").set(params[holderStartIndex], rawRet[i]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            ++i;
            ++holderStartIndex;
        }
    }
}

