/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.Binding;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.AbstractCachedOutputStream;
import org.apache.cxf.jaxws.handler.AbstractProtocolHandlerInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPMessageContextImpl;
import org.apache.cxf.message.Message;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPHandlerInterceptor
extends AbstractProtocolHandlerInterceptor<SoapMessage>
implements SoapInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SOAPHandlerInterceptor.class);

    public SOAPHandlerInterceptor(Binding binding) {
        super(binding);
        this.setPhase("pre-protocol");
        this.addBefore(new StaxOutInterceptor().getId());
    }

    public Set<URI> getRoles() {
        HashSet<URI> roles = new HashSet<URI>();
        return roles;
    }

    public Set<QName> getUnderstoodHeaders() {
        HashSet<QName> understood = new HashSet<QName>();
        for (Handler h : this.getBinding().getHandlerChain()) {
            Set headers;
            if (!(h instanceof SOAPHandler) || (headers = ((SOAPHandler)h).getHeaders()) == null) continue;
            understood.addAll(headers);
        }
        return understood;
    }

    @Override
    public void handleMessage(SoapMessage message) {
        if (this.getInvoker(message).isOutbound()) {
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            CachedStream cs = new CachedStream();
            message.setContent(OutputStream.class, (Object)cs);
            message.getInterceptorChain().doInterceptInSubChain((Message)message);
            super.handleMessage(message);
            try {
                SOAPMessage soapMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
                if (soapMessage != null) {
                    soapMessage.writeTo(os);
                } else {
                    cs.flush();
                    AbstractCachedOutputStream csnew = (AbstractCachedOutputStream)message.getContent(OutputStream.class);
                    AbstractCachedOutputStream.copyStream((InputStream)csnew.getInputStream(), (OutputStream)os, (int)65536);
                    cs.close();
                }
                os.flush();
                message.setContent(OutputStream.class, (Object)os);
            }
            catch (IOException ioe) {
                throw new SoapFault(new org.apache.cxf.common.i18n.Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), (Throwable)ioe, message.getVersion().getSender());
            }
            catch (SOAPException soape) {
                throw new SoapFault(new org.apache.cxf.common.i18n.Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), (Throwable)soape, message.getVersion().getSender());
            }
        }
        super.handleMessage(message);
        try {
            SOAPMessage soapMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
            if (soapMessage == null) {
                return;
            }
            SOAPBody body = soapMessage.getSOAPBody();
            CachedStream outStream = new CachedStream();
            XMLUtils.writeTo((Node)body, (OutputStream)((Object)outStream));
            XMLStreamReader reader = null;
            reader = XMLInputFactory.newInstance().createXMLStreamReader(outStream.getInputStream());
            if (reader.nextTag() == 1) {
                reader.getName();
            }
            reader.next();
            message.setContent(XMLStreamReader.class, (Object)reader);
            if (message.hasHeaders(Element.class)) {
                Element headerElements = (Element)message.getHeaders(Element.class);
                headerElements = soapMessage.getSOAPHeader();
                message.setHeaders(Element.class, (Object)headerElements);
            }
        }
        catch (IOException ioe) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), (Throwable)ioe, message.getVersion().getSender());
        }
        catch (SOAPException soape) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), (Throwable)soape, message.getVersion().getSender());
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("SOAPHANDLERINTERCEPTOR_EXCEPTION", BUNDLE, new Object[0]), (Throwable)e, message.getVersion().getSender());
        }
    }

    @Override
    protected MessageContext createProtocolMessageContext(Message message) {
        return new SOAPMessageContextImpl(message);
    }

    public void handleFault(SoapMessage message) {
    }

    private class CachedStream
    extends AbstractCachedOutputStream {
        private CachedStream() {
        }

        protected void doFlush() throws IOException {
            this.currentStream.flush();
        }

        protected void doClose() throws IOException {
        }

        protected void onWrite() throws IOException {
        }
    }
}

