/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.jaxws.servlet.ServletDestination;
import org.apache.cxf.jaxws.servlet.ServletTransportFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.tools.common.extensions.soap.SoapAddress;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.xmlsoap.schemas.wsdl.http.AddressType;

public class ServletController {
    static final String HTTP_REQUEST = "HTTP_SERVLET_REQUEST";
    static final String HTTP_RESPONSE = "HTTP_SERVLET_RESPONSE";
    private static final Logger LOG = Logger.getLogger(ServletController.class.getName());
    private ServletTransportFactory transport;
    private ServletContext servletContext;

    public ServletController(ServletTransportFactory df, ServletContext servCont) {
        this.transport = df;
        this.servletContext = servCont;
    }

    public void invoke(HttpServletRequest request, HttpServletResponse res) throws ServletException {
        String xsdName;
        boolean wsdl = false;
        boolean xsd = false;
        if (request.getQueryString() != null && request.getQueryString().trim().equalsIgnoreCase("wsdl")) {
            wsdl = true;
        }
        if ((xsdName = request.getRequestURI().substring(request.getRequestURI().lastIndexOf("/") + 1)) != null && xsdName.substring(xsdName.lastIndexOf(".") + 1).equalsIgnoreCase("xsd")) {
            xsd = true;
        }
        try {
            EndpointInfo ei = new EndpointInfo();
            ei.setAddress("http://localhost" + request.getServletPath() + request.getPathInfo());
            ServletDestination d = (ServletDestination)this.transport.getDestination(ei);
            if (d.getMessageObserver() == null) {
                if (xsd) {
                    this.generateXSD(request, res, xsdName);
                } else if (request.getRequestURI().endsWith("services")) {
                    this.generateServiceList(request, res);
                } else {
                    LOG.warning("Can't find the the request forhttp://localhost" + request.getServletPath() + request.getPathInfo() + " 's Observer ");
                    this.generateNotFound(request, res);
                }
            } else if (wsdl) {
                this.generateWSDL(request, res, d);
            } else {
                this.invokeDestination(request, res, d);
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void generateServiceList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<ServletDestination> destinations = this.transport.getDestinations();
        response.setContentType("text/html");
        response.getWriter().write("<html><body>");
        if (destinations.size() > 0) {
            for (ServletDestination sd : destinations) {
                if (null == sd.getEndpointInfo().getName()) continue;
                String address = sd.getAddress().getAddress().getValue();
                int bi = address.indexOf("http://localhost/services");
                address = request.getRequestURL() + address.substring(bi + "http://localhost/services".length());
                response.getWriter().write("<p> <a href=\"" + address + "?wsdl\">");
                response.getWriter().write(sd.getEndpointInfo().getName() + "</a> </p>");
            }
        } else {
            response.getWriter().write("No service was found.");
        }
        response.getWriter().write("</body></html>");
    }

    private void generateXSD(HttpServletRequest request, HttpServletResponse response, String xsdName) throws ServletException {
        response.setHeader("Content-Type", "text/xml");
        try {
            ServletOutputStream os = response.getOutputStream();
            StreamSource source = new StreamSource(this.servletContext.getResourceAsStream("/WEB-INF/wsdl/" + xsdName));
            StreamResult result = new StreamResult((OutputStream)os);
            TransformerFactory.newInstance().newTransformer().transform(source, result);
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void generateNotFound(HttpServletRequest request, HttpServletResponse res) throws IOException {
        res.setStatus(404);
        res.setContentType("text/html");
        res.getWriter().write("<html><body>No service was found.</body></html>");
    }

    public void invokeDestination(HttpServletRequest request, HttpServletResponse response, ServletDestination d) throws ServletException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Service http request on thread: " + Thread.currentThread());
        }
        try {
            MessageImpl inMessage = new MessageImpl();
            inMessage.setContent(InputStream.class, (Object)request.getInputStream());
            inMessage.put((Object)HTTP_REQUEST, (Object)request);
            inMessage.put((Object)HTTP_RESPONSE, (Object)response);
            inMessage.put((Object)Message.HTTP_REQUEST_METHOD, (Object)request.getMethod());
            inMessage.put((Object)Message.PATH_INFO, (Object)request.getPathInfo());
            inMessage.put((Object)Message.QUERY_STRING, (Object)request.getQueryString());
            inMessage.put((Object)"Content-Type", (Object)request.getContentType());
            inMessage.put((Object)Message.ENCODING, (Object)request.getCharacterEncoding());
            d.doMessage(inMessage);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void generateWSDL(HttpServletRequest request, HttpServletResponse response, ServletDestination d) throws ServletException {
        response.setHeader("Content-Type", "text/xml");
        try {
            ServletOutputStream os = response.getOutputStream();
            WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
            EndpointInfo ei = d.getEndpointInfo();
            Definition def = new ServiceWSDLBuilder(ei.getService()).build();
            Port port = def.getService(ei.getService().getName()).getPort(ei.getName().getLocalPart());
            List exts = port.getExtensibilityElements();
            if (exts.size() > 0) {
                SoapAddress add;
                ExtensibilityElement el = (ExtensibilityElement)exts.get(0);
                if (SOAPBindingUtil.isSOAPAddress((Object)el)) {
                    add = SOAPBindingUtil.getSoapAddress((Object)el);
                    add.setLocationURI(request.getRequestURL().toString());
                }
                if (el instanceof AddressType) {
                    add = (AddressType)el;
                    add.setLocation(request.getRequestURL().toString());
                }
            }
            wsdlWriter.writeWSDL(def, (OutputStream)os);
            response.getOutputStream().flush();
        }
        catch (WSDLException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

