/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxws.servlet.ServletDestination;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletTransportFactory
extends AbstractTransportFactory
implements DestinationFactory {
    private Bus bus;
    private Map<String, ServletDestination> destinations = new ConcurrentHashMap<String, ServletDestination>();

    public ServletTransportFactory(Bus b) {
        this.bus = b;
    }

    public ServletTransportFactory() {
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        ServletDestination d = this.destinations.get(endpointInfo.getAddress());
        if (d == null) {
            d = new ServletDestination(this.bus, null, endpointInfo);
            this.destinations.put(endpointInfo.getAddress(), d);
        }
        return d;
    }

    public List<ServletDestination> getDestinations() {
        ArrayList<ServletDestination> result = new ArrayList<ServletDestination>();
        for (ServletDestination sd : this.destinations.values()) {
            result.add(sd);
        }
        return result;
    }
}

