/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Binding;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.interceptor.ClientFaultConverter;
import org.apache.cxf.jaxws.binding.BindingImpl;
import org.apache.cxf.jaxws.binding.soap.SOAPBindingImpl;
import org.apache.cxf.jaxws.handler.AbstractJAXWSHandlerInterceptor;
import org.apache.cxf.jaxws.handler.LogicalHandlerInterceptor;
import org.apache.cxf.jaxws.handler.StreamHandlerInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassInInterceptor;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;

public class JaxWsEndpointImpl
extends EndpointImpl {
    private Binding binding;

    public JaxWsEndpointImpl(Bus bus, Service s, EndpointInfo ei) throws EndpointException {
        super(bus, s, ei);
        this.createJaxwsBinding();
        ArrayList<AbstractJAXWSHandlerInterceptor> handlerInterceptors = new ArrayList<AbstractJAXWSHandlerInterceptor>();
        handlerInterceptors.add(new LogicalHandlerInterceptor(this.binding));
        if (this.getBinding() instanceof SoapBinding) {
            handlerInterceptors.add(new SOAPHandlerInterceptor(this.binding));
        }
        handlerInterceptors.add(new StreamHandlerInterceptor(this.binding));
        List fault = super.getOutFaultInterceptors();
        fault.addAll(handlerInterceptors);
        List in = super.getInInterceptors();
        in.addAll(handlerInterceptors);
        in.add(new WrapperClassInInterceptor());
        List out = super.getOutInterceptors();
        out.addAll(handlerInterceptors);
        out.add(new WrapperClassOutInterceptor());
        this.getInFaultInterceptors().add(new ClientFaultConverter());
    }

    public Binding getJaxwsBinding() {
        return this.binding;
    }

    final void createJaxwsBinding() {
        this.binding = this.getBinding() instanceof SoapBinding ? new SOAPBindingImpl(this.getEndpointInfo().getBinding()) : new BindingImpl();
    }
}

