/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ResourceBundle;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceException;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.DefaultServiceConfiguration;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsServiceConfiguration
extends AbstractServiceConfiguration {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JaxWsServiceConfiguration.class);
    private JaxWsImplementorInfo implInfo;

    public void setServiceFactory(ReflectionServiceFactoryBean serviceFactory) {
        super.setServiceFactory(serviceFactory);
        this.implInfo = ((JaxWsServiceFactoryBean)serviceFactory).getJaxWsImplementorInfo();
    }

    WebService getConcreteWebServiceAttribute() {
        return this.getServiceFactory().getServiceClass().getAnnotation(WebService.class);
    }

    WebService getPortTypeWebServiceAttribute() {
        Class<?> epi = this.implInfo.getEndpointClass();
        WebService ws = null;
        if (epi != null) {
            ws = epi.getAnnotation(WebService.class);
        }
        if (ws == null) {
            ws = this.getConcreteWebServiceAttribute();
        }
        return ws;
    }

    public String getServiceName() {
        WebService ws = this.getConcreteWebServiceAttribute();
        if (ws != null && ws.serviceName().length() > 0) {
            return ws.serviceName();
        }
        return null;
    }

    public String getServiceNamespace() {
        WebService ws = this.getConcreteWebServiceAttribute();
        if (ws != null && ws.targetNamespace().length() > 0) {
            return ws.targetNamespace();
        }
        return null;
    }

    public QName getEndpointName() {
        return this.implInfo.getEndpointName();
    }

    public URL getWsdlURL() {
        WebService ws = this.getPortTypeWebServiceAttribute();
        if (ws != null && ws.wsdlLocation().length() > 0) {
            try {
                URIResolver resolver = new URIResolver(null, ws.wsdlLocation(), ((Object)((Object)this)).getClass());
                if (resolver.isResolved()) {
                    return resolver.getURI().toURL();
                }
                throw new WebServiceException("Could not find WSDL with URL " + ws.wsdlLocation());
            }
            catch (IOException e) {
                throw new ServiceConstructionException(new Message("LOAD_WSDL_EXC", BUNDLE, new Object[]{ws.wsdlLocation()}), (Throwable)e);
            }
        }
        return null;
    }

    public QName getOperationName(InterfaceInfo intf, Method method) {
        WebMethod wm = (method = this.getDeclaredMethod(method)).getAnnotation(WebMethod.class);
        if (wm != null) {
            String name = wm.operationName();
            if (name.length() == 0) {
                name = method.getName();
            }
            return new QName(intf.getName().getNamespaceURI(), name);
        }
        return null;
    }

    public Boolean isOperation(Method method) {
        if ((method = this.getDeclaredMethod(method)) != null) {
            WebMethod wm = method.getAnnotation(WebMethod.class);
            if (wm != null) {
                if (wm.exclude()) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return this.hasWebServiceAnnotation(method);
        }
        return Boolean.FALSE;
    }

    private boolean hasWebServiceAnnotation(Method method) {
        return method.getDeclaringClass().getAnnotation(WebService.class) != null;
    }

    Method getDeclaredMethod(Method method) {
        Class<?> endpointClass = this.implInfo.getEndpointClass();
        if (!method.getDeclaringClass().equals(endpointClass)) {
            try {
                method = endpointClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (SecurityException e) {
                throw new ServiceConstructionException((Throwable)e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }

    public QName getInPartName(OperationInfo op, Method method, int paramNumber) {
        if (paramNumber < 0) {
            return null;
        }
        return this.getPartName(op, method, paramNumber, "arg" + paramNumber);
    }

    public QName getInParameterName(OperationInfo op, Method method, int paramNumber) {
        if (paramNumber < 0) {
            return null;
        }
        return this.getParameterName(op, method, paramNumber, "arg" + paramNumber);
    }

    private QName getPartName(OperationInfo op, Method method, int paramNumber, String prefix) {
        WebParam param = this.getWebParam(method, paramNumber);
        String tns = op.getName().getNamespaceURI();
        if (param != null) {
            String local = param.partName();
            if (local.length() == 0) {
                local = param.name();
            }
            if (local.length() == 0) {
                this.getDefaultLocalName(op, method, paramNumber, prefix);
            }
            return new QName(tns, local);
        }
        return new QName(tns, prefix);
    }

    private QName getParameterName(OperationInfo op, Method method, int paramNumber, String prefix) {
        WebParam param = this.getWebParam(method, paramNumber);
        if (param != null) {
            String tns = param.targetNamespace();
            String local = param.name();
            if (tns.length() == 0) {
                tns = op.getName().getNamespaceURI();
            }
            if (local.length() == 0) {
                local = this.getDefaultLocalName(op, method, paramNumber, prefix);
            }
            return new QName(tns, local);
        }
        return null;
    }

    private String getDefaultLocalName(OperationInfo op, Method method, int paramNumber, String prefix) {
        Class<?> impl = this.implInfo.getImplementorClass();
        if (impl == null) {
            try {
                method = impl.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (Exception e) {
                throw new ServiceConstructionException((Throwable)e);
            }
        }
        return DefaultServiceConfiguration.createName((Method)method, (int)paramNumber, (int)op.getInput().getMessageParts().size(), (boolean)false, (String)prefix);
    }

    private WebParam getWebParam(Method method, int parameter) {
        Annotation[][] annotations = method.getParameterAnnotations();
        if (parameter >= annotations.length) {
            return null;
        }
        for (int i = 0; i < annotations[parameter].length; ++i) {
            Annotation annotation = annotations[parameter][i];
            if (!annotation.annotationType().equals(WebParam.class)) continue;
            return (WebParam)annotation;
        }
        return null;
    }

    public QName getOutParameterName(OperationInfo op, Method method, int paramNumber) {
        if (paramNumber >= 0) {
            return this.getParameterName(op, method, paramNumber, "return");
        }
        WebResult webResult = this.getWebResult(method);
        if (webResult != null) {
            String tns = webResult.targetNamespace();
            String local = webResult.name();
            if (tns.length() == 0) {
                tns = op.getName().getNamespaceURI();
            }
            if (local.length() == 0) {
                local = this.getDefaultLocalName(op, method, paramNumber, "return");
            }
            return new QName(tns, local);
        }
        return super.getOutParameterName(op, method, paramNumber);
    }

    public QName getOutPartName(OperationInfo op, Method method, int paramNumber) {
        if (paramNumber >= 0) {
            return this.getPartName(op, method, paramNumber, "return");
        }
        WebResult webResult = this.getWebResult(method);
        String tns = op.getName().getNamespaceURI();
        if (webResult != null) {
            String local = webResult.partName();
            if (local.length() == 0) {
                local = webResult.name();
            }
            if (local.length() == 0) {
                local = this.getDefaultLocalName(op, method, paramNumber, "return");
            }
            return new QName(tns, local);
        }
        return new QName(tns, "return");
    }

    public Boolean isInParam(Method method, int j) {
        if (j < 0) {
            return Boolean.FALSE;
        }
        WebParam webParam = this.getWebParam(method, j);
        return webParam == null || webParam.mode().equals((Object)WebParam.Mode.IN) || webParam.mode().equals((Object)WebParam.Mode.INOUT);
    }

    private WebResult getWebResult(Method method) {
        return method.getAnnotation(WebResult.class);
    }

    public Boolean isOutParam(Method method, int j) {
        if (j == -1) {
            return !method.getReturnType().equals(Void.TYPE);
        }
        WebParam webParam = this.getWebParam(method, j);
        return webParam != null && (webParam.mode().equals((Object)WebParam.Mode.OUT) || webParam.mode().equals((Object)WebParam.Mode.INOUT));
    }

    public Class getResponseWrapper(Method selected) {
        Method m = this.getDeclaredMethod(selected);
        ResponseWrapper rw = m.getAnnotation(ResponseWrapper.class);
        if (rw == null) {
            return null;
        }
        String clsName = rw.className();
        if (clsName.length() > 0) {
            try {
                return ClassLoaderUtils.loadClass((String)clsName, ((Object)((Object)this)).getClass());
            }
            catch (ClassNotFoundException e) {
                throw new ServiceConstructionException((Throwable)e);
            }
        }
        return null;
    }

    public Class getRequestWrapper(Method selected) {
        Method m = this.getDeclaredMethod(selected);
        RequestWrapper rw = m.getAnnotation(RequestWrapper.class);
        if (rw == null) {
            return null;
        }
        String clsName = rw.className();
        if (clsName.length() > 0) {
            try {
                return ClassLoaderUtils.loadClass((String)clsName, ((Object)((Object)this)).getClass());
            }
            catch (ClassNotFoundException e) {
                throw new ServiceConstructionException((Throwable)e);
            }
        }
        return null;
    }

    public QName getFaultName(InterfaceInfo service, OperationInfo o, Class<?> exClass, Class<?> beanClass) {
        WebFault fault = exClass.getAnnotation(WebFault.class);
        if (fault != null) {
            String ns;
            String name = fault.name();
            if (name.length() == 0) {
                name = exClass.getSimpleName();
            }
            if ((ns = fault.targetNamespace()).length() == 0) {
                ns = service.getName().getNamespaceURI();
            }
            return new QName(ns, name);
        }
        return null;
    }

    public Boolean isWrapped(Method m) {
        if (!this.getServiceFactory().isWrapped()) {
            return Boolean.FALSE;
        }
        SOAPBinding ann = m.getAnnotation(SOAPBinding.class);
        if (ann != null) {
            if (ann.style().equals((Object)SOAPBinding.Style.RPC)) {
                throw new Fault((Throwable)new RuntimeException("Method [" + m.getName() + "] processing error: " + "SOAPBinding can not on method with RPC style"));
            }
            return !ann.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE);
        }
        return this.isWrapped();
    }

    public Boolean isWrapped() {
        SOAPBinding ann = this.implInfo.getEndpointClass().getAnnotation(SOAPBinding.class);
        if (ann != null) {
            return !ann.parameterStyle().equals((Object)SOAPBinding.ParameterStyle.BARE) && !ann.style().equals((Object)SOAPBinding.Style.RPC);
        }
        return null;
    }
}

