/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.ProviderServiceFactoryBean;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;

public class WebServiceProviderConfiguration
extends AbstractServiceConfiguration {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(WebServiceProviderConfiguration.class);
    private JaxWsImplementorInfo implInfo;
    private WebServiceProvider wsProvider;

    public void setServiceFactory(ReflectionServiceFactoryBean serviceFactory) {
        super.setServiceFactory(serviceFactory);
        this.implInfo = ((ProviderServiceFactoryBean)serviceFactory).getJaxWsImplementorInfo();
        this.wsProvider = this.implInfo.getWsProvider();
    }

    public String getServiceName() {
        if (this.wsProvider.serviceName().length() > 0) {
            return this.wsProvider.serviceName();
        }
        return null;
    }

    public String getServiceNamespace() {
        if (this.wsProvider.targetNamespace().length() > 0) {
            return this.wsProvider.targetNamespace();
        }
        return null;
    }

    public QName getEndpointName() {
        return this.implInfo.getEndpointName();
    }

    public URL getWsdlURL() {
        String loc = this.wsProvider.wsdlLocation();
        if (loc.length() > 0) {
            try {
                URIResolver resolver = new URIResolver(null, loc, ((Object)((Object)this)).getClass());
                if (resolver.isResolved()) {
                    return resolver.getURI().toURL();
                }
                throw new WebServiceException("Could not find WSDL with URL " + loc);
            }
            catch (IOException e) {
                throw new ServiceConstructionException(new Message("LOAD_WSDL_EXC", BUNDLE, new Object[]{loc}), (Throwable)e);
            }
        }
        return null;
    }
}

