/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.List;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMProperties;

public final class RMContextUtils {
    protected RMContextUtils() {
    }

    public static String generateUUID() {
        return ContextUtils.generateUUID();
    }

    public static boolean isOutbound(Message message) {
        return ContextUtils.isOutbound((Message)message);
    }

    public static boolean isRequestor(Message message) {
        return ContextUtils.isRequestor((Message)message);
    }

    public static boolean isServerSide(Message message) {
        if (RMContextUtils.isOutbound(message)) {
            return message.getExchange().getInMessage() != null;
        }
        return message.getExchange().getOutMessage() == null && message.getExchange().getOutFaultMessage() == null;
    }

    public static boolean isPartialResponse(Message message) {
        return RMContextUtils.isOutbound(message) && message.getContent(List.class) == null && RMContextUtils.getException(message.getExchange()) == null;
    }

    public static boolean isAplicationMessage(String action) {
        return !RMConstants.getCreateSequenceAction().equals(action) && !RMConstants.getCreateSequenceResponseAction().equals(action) && !RMConstants.getTerminateSequenceAction().equals(action) && !RMConstants.getLastMessageAction().equals(action) && !RMConstants.getSequenceAcknowledgmentAction().equals(action) && !RMConstants.getSequenceInfoAction().equals(action);
    }

    public static RMProperties retrieveRMProperties(Message message, boolean outbound) {
        if (outbound) {
            return (RMProperties)message.get((Object)RMContextUtils.getRMPropertiesKey(true));
        }
        Message m = null;
        if (RMContextUtils.isOutbound(message)) {
            m = message.getExchange().getInMessage();
            if (null == m) {
                m = message.getExchange().getInFaultMessage();
            }
        } else {
            m = message;
        }
        if (null != m) {
            return (RMProperties)m.get((Object)RMContextUtils.getRMPropertiesKey(false));
        }
        return null;
    }

    public static void storeRMProperties(Message message, RMProperties rmps, boolean outbound) {
        String key = RMContextUtils.getRMPropertiesKey(outbound);
        message.put((Object)key, (Object)rmps);
    }

    public static AddressingPropertiesImpl retrieveMAPs(Message message, boolean isProviderContext, boolean isOutbound) {
        return ContextUtils.retrieveMAPs((Message)message, (boolean)isProviderContext, (boolean)isOutbound);
    }

    public static void storeMAPs(AddressingProperties maps, Message message, boolean isProviderContext, boolean isOutbound) {
        ContextUtils.storeMAPs((AddressingProperties)maps, (Message)message, (boolean)isProviderContext, (boolean)isOutbound);
    }

    public static void ensureExposedVersion(AddressingProperties maps) {
        ((AddressingPropertiesImpl)maps).exposeAs("http://schemas.xmlsoap.org/ws/2004/08/addressing");
    }

    public static Endpoint getEndpoint(Message message) {
        return (Endpoint)message.getExchange().get(Endpoint.class);
    }

    private static String getRMPropertiesKey(boolean outbound) {
        return outbound ? "org.apache.cxf.ws.rm.outbound" : "org.apache.cxf.ws.rm.inbound";
    }

    private static Exception getException(Exchange exchange) {
        if (exchange.getOutFaultMessage() != null) {
            return (Exception)exchange.getOutFaultMessage().getContent(Exception.class);
        }
        if (exchange.getInFaultMessage() != null) {
            return (Exception)exchange.getInFaultMessage().getContent(Exception.class);
        }
        return null;
    }
}

