/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.xml.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.WrappedInInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

public class XMLMessageInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = Logger.getLogger(XMLMessageInInterceptor.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(XMLMessageInInterceptor.class);
    private BareInInterceptor bareInterceptor = new BareInInterceptor();
    private WrappedInInterceptor wrappedInterceptor = new WrappedInInterceptor();

    public XMLMessageInInterceptor() {
        this.setPhase("unmarshal");
    }

    public void handleMessage(Message message) throws Fault {
        if (this.isGET(message)) {
            LOG.info("XMLMessageInInterceptor skipped in HTTP GET method");
            return;
        }
        XMLStreamReader xsr = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        DepthXMLStreamReader reader = new DepthXMLStreamReader(xsr);
        Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
        BindingInfo service = ep.getEndpointInfo().getBinding();
        if (!StaxUtils.toNextElement((DepthXMLStreamReader)reader)) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OPERATION_ELEMENT", BUNDLE, new Object[0]));
        }
        Exchange ex = message.getExchange();
        QName startQName = reader.getName();
        if (startQName.getLocalPart().equals("XMLFault")) {
            message.getInterceptorChain().abort();
            if (ep.getInFaultObserver() != null) {
                ep.getInFaultObserver().onMessage(message);
                return;
            }
        }
        BindingOperationInfo bop = (BindingOperationInfo)ex.get(BindingOperationInfo.class);
        MessagePartInfo part = null;
        if (bop == null) {
            ArrayList operations = new ArrayList();
            operations.addAll(service.getInterface().getOperations());
            part = this.findMessagePart(ex, operations, startQName, false, 0);
        } else {
            MessageInfo msgInfo = this.getMessageInfo(message, bop, ex);
            if (msgInfo.getMessageParts().size() > 0) {
                part = (MessagePartInfo)msgInfo.getMessageParts().get(0);
            }
        }
        if (part != null && part.getMessageInfo().getMessageParts().size() == 1) {
            OperationInfo o = part.getMessageInfo().getOperation();
            if (!o.isUnwrappedCapable()) {
                this.bareInterceptor.handleMessage(message);
                return;
            }
            this.wrappedInterceptor.handleMessage(message);
            return;
        }
        QName name = new QName(service.getInterface().getName().getNamespaceURI(), "multiParamRootReq");
        if (reader.getName().equals(name)) {
            StaxUtils.nextEvent((XMLStreamReader)reader);
            StaxUtils.toNextElement((DepthXMLStreamReader)reader);
            this.bareInterceptor.handleMessage(message);
            return;
        }
        bop = ServiceModelUtil.getOperation((Exchange)ex, (QName)reader.getName());
        if (bop != null) {
            ex.put(BindingOperationInfo.class, (Object)bop);
            this.getMessageInfo(message, bop, ex);
            message.setContent(List.class, (Object)Collections.EMPTY_LIST);
            return;
        }
        throw new Fault(new org.apache.cxf.common.i18n.Message("REQ_NOT_UNDERSTOOD", BUNDLE, new Object[]{startQName}));
    }
}

