/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.extensions.soap.SoapBinding;
import org.apache.cxf.tools.common.extensions.soap.SoapBody;
import org.apache.cxf.tools.common.extensions.soap.SoapFault;
import org.apache.cxf.tools.common.extensions.soap.SoapHeader;
import org.apache.cxf.tools.common.extensions.soap.SoapOperation;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.WSDLModel;
import org.apache.cxf.tools.common.model.WSDLParameter;
import org.apache.cxf.tools.java2wsdl.processor.JavaToWSDLProcessor;
import org.apache.cxf.tools.util.SOAPBindingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingGenerator {
    private static final Logger LOG = LogUtils.getL7dLogger(JavaToWSDLProcessor.class);
    private WSDLModel wmodel;
    private Definition definition;
    private ExtensionRegistry extensionRegistry;

    public BindingGenerator(WSDLModel model) {
        this.wmodel = model;
        this.definition = model.getDefinition();
        this.extensionRegistry = this.definition.getExtensionRegistry();
    }

    public void generate() {
        this.generate(false);
    }

    public void generate(boolean isSOAP12) {
        Binding binding = this.definition.createBinding();
        binding.setQName(new QName("http://schemas.xmlsoap.org/wsdl/", this.wmodel.getPortTypeName() + "Binding"));
        binding.setPortType(this.definition.getPortType(new QName(this.wmodel.getTargetNameSpace(), this.wmodel.getPortTypeName())));
        SoapBinding soapBinding = null;
        try {
            soapBinding = SOAPBindingUtil.createSoapBinding((ExtensionRegistry)this.extensionRegistry, (boolean)isSOAP12);
            soapBinding.setStyle(this.wmodel.getStyle().toString().toLowerCase());
            binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
        try {
            this.generateBindingOperation(binding, isSOAP12);
        }
        catch (WSDLException e) {
            throw new ToolException(e.getMessage(), (Throwable)e);
        }
        binding.setUndefined(false);
        this.definition.addBinding(binding);
    }

    private void generateBindingOperation(Binding binding, boolean isSOAP12) throws WSDLException {
        for (JavaMethod jmethod : this.wmodel.getJavaMethods()) {
            BindingOperation bindOperation = this.definition.createBindingOperation();
            bindOperation.setName(jmethod.getName());
            this.generateBindingOperationInputOutPut(bindOperation, jmethod, isSOAP12);
            binding.addBindingOperation(bindOperation);
        }
    }

    private void generateBindingOperationInputOutPut(BindingOperation operation, JavaMethod jmethod, boolean isSOAP12) throws WSDLException {
        SoapOperation soapOperation = SOAPBindingUtil.createSoapOperation((ExtensionRegistry)this.extensionRegistry, (boolean)isSOAP12);
        soapOperation.setStyle(jmethod.getSoapStyle().name().toLowerCase());
        if (jmethod.getSoapAction() != null && !jmethod.getSoapAction().equals("")) {
            soapOperation.setSoapActionURI(jmethod.getSoapAction());
        }
        operation.addExtensibilityElement((ExtensibilityElement)soapOperation);
        this.generateInputSoapBody(jmethod, operation, jmethod.getRequest(), isSOAP12);
        this.generateOutputSoapBody(jmethod, operation, jmethod.getResponse(), isSOAP12);
        for (org.apache.cxf.tools.common.model.WSDLException ex : jmethod.getWSDLExceptions()) {
            BindingFault bindingFault = this.definition.createBindingFault();
            bindingFault.setName(ex.getExcpetionClass().getSimpleName());
            operation.addBindingFault(bindingFault);
            SoapFault soapFault = SOAPBindingUtil.createSoapFault((ExtensionRegistry)this.extensionRegistry, (boolean)isSOAP12);
            soapFault.setUse("literal");
            soapFault.setName(ex.getExcpetionClass().getSimpleName());
            bindingFault.addExtensibilityElement((ExtensibilityElement)soapFault);
        }
    }

    private void generateOutputSoapBody(JavaMethod jmethod, BindingOperation operation, WSDLParameter param, boolean isSOAP12) throws WSDLException {
        if (param == null) {
            return;
        }
        BindingOutput bindingOutput = this.definition.createBindingOutput();
        bindingOutput.setName(param.getName());
        operation.setBindingOutput(bindingOutput);
        SoapBody body = SOAPBindingUtil.createSoapBody((ExtensionRegistry)this.extensionRegistry, BindingOutput.class, (boolean)isSOAP12);
        if (jmethod.getSoapUse() != SOAPBinding.Use.LITERAL) {
            Message msg = new Message("ENCODED_USE_NOT_SUPPORTED", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        body.setUse("literal");
        ArrayList<JavaParameter> bodyParams = new ArrayList<JavaParameter>();
        ArrayList<JavaParameter> headerParams = new ArrayList<JavaParameter>();
        this.splitSoapHeaderBodyParams(param, bodyParams, headerParams);
        if (headerParams.size() > 0) {
            ArrayList<String> parts = new ArrayList<String>();
            for (JavaParameter parameter : bodyParams) {
                parts.add(parameter.getPartName());
            }
            body.setParts(parts);
            SoapHeader soapHeader = null;
            for (JavaParameter jp : headerParams) {
                soapHeader = SOAPBindingUtil.createSoapHeader((ExtensionRegistry)this.extensionRegistry, BindingOutput.class, (boolean)isSOAP12);
                soapHeader.setMessage(new QName(param.getTargetNamespace(), param.getName()));
                soapHeader.setPart(jp.getPartName());
                soapHeader.setUse("literal");
            }
            if (jmethod.getSoapStyle() == SOAPBinding.Style.RPC) {
                body.setNamespaceURI(param.getTargetNamespace());
            }
            bindingOutput.addExtensibilityElement(soapHeader);
        }
        bindingOutput.addExtensibilityElement((ExtensibilityElement)body);
    }

    private void generateInputSoapBody(JavaMethod jmethod, BindingOperation operation, WSDLParameter param, boolean isSOAP12) throws WSDLException {
        if (param == null) {
            return;
        }
        BindingInput bindingInput = this.definition.createBindingInput();
        bindingInput.setName(param.getName());
        operation.setBindingInput(bindingInput);
        SoapBody body = SOAPBindingUtil.createSoapBody((ExtensionRegistry)this.extensionRegistry, BindingInput.class, (boolean)isSOAP12);
        if (jmethod.getSoapUse() != SOAPBinding.Use.LITERAL) {
            Message msg = new Message("ENCODED_USE_NOT_SUPPORTED", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        body.setUse("literal");
        ArrayList<JavaParameter> bodyParams = new ArrayList<JavaParameter>();
        ArrayList<JavaParameter> headerParams = new ArrayList<JavaParameter>();
        this.splitSoapHeaderBodyParams(param, bodyParams, headerParams);
        if (headerParams.size() > 0) {
            ArrayList<String> parts = new ArrayList<String>();
            for (JavaParameter parameter : bodyParams) {
                parts.add(parameter.getPartName());
            }
            body.setParts(parts);
            SoapHeader soapHeader = null;
            for (JavaParameter jp : headerParams) {
                soapHeader = SOAPBindingUtil.createSoapHeader((ExtensionRegistry)this.extensionRegistry, BindingInput.class, (boolean)isSOAP12);
                soapHeader.setMessage(new QName(param.getTargetNamespace(), param.getName()));
                soapHeader.setPart(jp.getPartName());
                soapHeader.setUse("literal");
            }
            if (jmethod.getSoapStyle() == SOAPBinding.Style.RPC) {
                body.setNamespaceURI(param.getTargetNamespace());
            }
            bindingInput.addExtensibilityElement(soapHeader);
        }
        bindingInput.addExtensibilityElement((ExtensibilityElement)body);
    }

    private void splitSoapHeaderBodyParams(WSDLParameter param, List<JavaParameter> bodyList, List<JavaParameter> headerList) {
        for (JavaParameter jpara : param.getChildren()) {
            if (jpara.isHeader()) {
                headerList.add(jpara);
                continue;
            }
            bodyList.add(jpara);
        }
    }
}

