/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator;

import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.extensions.soap.SoapAddress;
import org.apache.cxf.tools.common.model.WSDLModel;
import org.apache.cxf.tools.util.SOAPBindingUtil;

public class ServiceGenerator {
    private WSDLModel wmodel;
    private Definition definition;
    private ExtensionRegistry extensionRegistry;

    public ServiceGenerator(WSDLModel model) {
        this.definition = model.getDefinition();
        this.wmodel = model;
        this.extensionRegistry = this.definition.getExtensionRegistry();
    }

    public void generate() {
        this.generate(false);
    }

    private String getAddressName() {
        String contextName = this.wmodel.getServiceName();
        if (StringUtils.isEmpty((String)contextName)) {
            contextName = "changeme";
        }
        return "http://localhost:9000/" + contextName;
    }

    public void generate(boolean isSOAP12) {
        Service service = this.definition.createService();
        service.setQName(new QName("wsdl", this.wmodel.getServiceName()));
        Port port = this.definition.createPort();
        port.setName(this.wmodel.getPortName());
        Binding binding = this.definition.createBinding();
        String targetNameSpace = this.wmodel.getTargetNameSpace();
        binding.setQName(new QName(targetNameSpace, this.wmodel.getPortTypeName() + "Binding"));
        port.setBinding(binding);
        SoapAddress soapAddress = null;
        try {
            soapAddress = SOAPBindingUtil.createSoapAddress((ExtensionRegistry)this.extensionRegistry, (boolean)isSOAP12);
            soapAddress.setLocationURI(this.getAddressName());
        }
        catch (WSDLException e) {
            throw new ToolException(e.getMessage(), (Throwable)e);
        }
        port.addExtensibilityElement((ExtensibilityElement)soapAddress);
        service.addPort(port);
        this.definition.addService(service);
    }
}

