/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator;

import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.WSDLModel;
import org.apache.cxf.tools.java2wsdl.generator.WSDLOutputResolver;
import org.apache.cxf.tools.java2wsdl.processor.JavaToWSDLProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TypesGenerator {
    private static final Logger LOG = LogUtils.getL7dLogger(JavaToWSDLProcessor.class);
    private WSDLModel wmodel;
    private Definition definition;
    private ExtensionRegistry extensionRegistry;
    private ToolContext env;

    public TypesGenerator(WSDLModel model, ToolContext penv) {
        this.definition = model.getDefinition();
        this.wmodel = model;
        this.env = penv;
        this.extensionRegistry = this.definition.getExtensionRegistry();
    }

    public void generate() {
        Message msg = new Message("GENERATE_TYPES_ERROR", LOG, new Object[0]);
        try {
            this.wmodel.createJAXBContext();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Create jaxbContext error");
            throw new ToolException(msg, (Throwable)e);
        }
        WSDLOutputResolver resolver = new WSDLOutputResolver(this.env, this.wmodel);
        try {
            this.wmodel.getJaxbContext().generateSchema((SchemaOutputResolver)resolver);
        }
        catch (Exception e2) {
            throw new ToolException(msg, (Throwable)e2);
        }
        Types types = this.definition.createTypes();
        try {
            Schema schema = (Schema)this.extensionRegistry.createExtension(Types.class, new QName("http://www.w3.org/2001/XMLSchema", "schema"));
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element element = doc.createElement("xsd:schema");
            Map schemafileMap = this.wmodel.getSchemaNSFileMap();
            Set entryset = schemafileMap.entrySet();
            for (Map.Entry entry : entryset) {
                Element importelement = doc.createElement("xsd:import");
                importelement.setAttribute("namespace", (String)entry.getKey());
                importelement.setAttribute("schemaLocation", (String)entry.getValue());
                element.appendChild(importelement);
            }
            schema.setElement(element);
            types.addExtensibilityElement((ExtensibilityElement)schema);
            this.definition.setTypes(types);
        }
        catch (Exception e) {
            throw new ToolException(msg, (Throwable)e);
        }
        this.definition.setTargetNamespace(this.wmodel.getTargetNameSpace());
        this.definition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.definition.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.definition.addNamespace("tns", this.wmodel.getTargetNameSpace());
        int i = 0;
        for (String s : this.wmodel.getJaxbContext().getKnownNamespaceURIs()) {
            this.definition.addNamespace("ns" + ++i, s);
        }
    }
}

