/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import com.sun.xml.bind.v2.model.annotation.RuntimeAnnotationReader;
import com.sun.xml.bind.v2.model.annotation.RuntimeInlineAnnotationReader;
import com.sun.xml.bind.v2.model.core.Element;
import com.sun.xml.bind.v2.model.core.NonElement;
import com.sun.xml.bind.v2.model.impl.RuntimeModelBuilder;
import javax.xml.namespace.QName;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaCollection;

class JAXBSchemaInitializer
extends ServiceModelVisitor {
    private XmlSchemaCollection schemas;

    public JAXBSchemaInitializer(ServiceInfo serviceInfo, XmlSchemaCollection col) {
        super(serviceInfo);
        this.schemas = col;
    }

    public void begin(MessagePartInfo part) {
        if (part.getTypeQName() != null || part.getElementQName() != null) {
            return;
        }
        Class clazz = part.getTypeClass();
        if (clazz == null) {
            return;
        }
        RuntimeModelBuilder builder = new RuntimeModelBuilder((RuntimeAnnotationReader)new RuntimeInlineAnnotationReader(), null);
        NonElement typeInfo = builder.getTypeInfo((Object)clazz, null);
        QName typeName = typeInfo.getTypeName();
        if (typeName == null) {
            return;
        }
        boolean isElement = typeInfo instanceof Element;
        if (isElement) {
            isElement = ((Element)typeInfo).getElementName() != null;
        }
        part.setElement(isElement);
        if (isElement) {
            QName name = ((Element)typeInfo).getElementName();
            part.setElementQName(name);
            part.setXmlSchema((XmlSchemaAnnotated)this.schemas.getElementByQName(name));
        } else {
            part.setTypeQName(typeName);
            part.setXmlSchema((XmlSchemaAnnotated)this.schemas.getTypeByQName(typeName));
        }
    }
}

