/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.attachment;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.attachment.AttachmentMarshaller;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

public class JAXBAttachmentMarshaller
extends AttachmentMarshaller {
    private static final int THRESH_HOLD = 65536;
    private Message message;
    private Collection<Attachment> atts;
    private boolean isXop;

    public JAXBAttachmentMarshaller(Message messageParam) {
        this.message = messageParam;
        if (this.message.getAttachments() == null) {
            this.message.setAttachments(new ArrayList());
        }
        this.atts = this.message.getAttachments();
    }

    public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNS, String elementLocalName) {
        String id;
        if (!this.isXop && length < 65536) {
            return null;
        }
        ByteDataSource source = new ByteDataSource(data, offset, length);
        if (mimeType != null) {
            source.setContentType(mimeType);
        } else {
            source.setContentType("application/octet-stream");
        }
        DataHandler handler = new DataHandler((DataSource)source);
        try {
            id = AttachmentUtil.createContentID((String)elementNS);
        }
        catch (UnsupportedEncodingException e) {
            throw new Fault((Throwable)e);
        }
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(this.isXop);
        this.atts.add((Attachment)att);
        return "cid:" + id;
    }

    public String addMtomAttachment(DataHandler handler, String elementNS, String elementLocalName) {
        String id;
        if (!this.isXop) {
            return null;
        }
        try {
            id = AttachmentUtil.createContentID((String)elementNS);
        }
        catch (UnsupportedEncodingException e) {
            throw new Fault((Throwable)e);
        }
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(this.isXop);
        this.atts.add((Attachment)att);
        return "cid:" + id;
    }

    public String addSwaRefAttachment(DataHandler handler) {
        String id = UUID.randomUUID() + "@apache.org";
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(false);
        this.atts.add((Attachment)att);
        return id;
    }

    public void setXOPPackage(boolean xop) {
        this.isXop = xop;
    }

    public boolean isXOPPackage() {
        return this.isXop;
    }
}

