/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import java.io.InputStream;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.jaxb.JAXBDataReaderFactory;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.service.model.MessagePartInfo;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLMessageDataReader
implements DataReader<XMLMessage> {
    final JAXBDataReaderFactory factory;

    public XMLMessageDataReader(JAXBDataReaderFactory cb) {
        this.factory = cb;
    }

    public Object read(XMLMessage input) {
        return null;
    }

    public Object read(MessagePartInfo part, XMLMessage input) {
        return null;
    }

    public Object read(QName name, XMLMessage input, Class type) {
        Source obj = null;
        InputStream is = (InputStream)input.getContent(InputStream.class);
        try {
            if (is == null || is.available() == 0) {
                return null;
            }
            if (DOMSource.class.isAssignableFrom(type)) {
                Document doc = XMLUtils.parse((InputStream)is);
                obj = new DOMSource(doc);
            } else if (SAXSource.class.isAssignableFrom(type)) {
                obj = new SAXSource(new InputSource(is));
            } else if (StreamSource.class.isAssignableFrom(type) || Source.class.isAssignableFrom(type)) {
                obj = new StreamSource(is);
            }
            if (MimePartDataSource.class.isAssignableFrom(type)) {
                obj = new MimePartDataSource((MimePart)new MimeBodyPart(is));
            } else if (ByteArrayDataSource.class.isAssignableFrom(type) || DataSource.class.isAssignableFrom(type)) {
                obj = new ByteArrayDataSource(is, null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return obj;
    }
}

