/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.cxf.transport.jms.JMSSessionFactory;
import org.apache.cxf.transport.jms.JMSTransportBase;
import org.apache.cxf.transport.jms.JMSUtils;
import org.apache.cxf.transport.jms.destination.JMSDestinationConfigBean;
import org.apache.cxf.transports.jms.JMSAddressPolicyType;

public final class JMSProviderHub {
    private JMSProviderHub() {
    }

    public String toString() {
        return "JMSProviderHub";
    }

    protected static void connect(JMSTransportBase jmsTransport, JMSDestinationConfigBean jmsDestConfigBean) throws JMSException, NamingException {
        String clientID;
        JMSAddressPolicyType addrDetails = jmsTransport.getAddressPolicy();
        Context context = JMSUtils.getInitialContext(addrDetails);
        QueueConnection connection = null;
        if ("queue".equals(addrDetails.getDestinationStyle().value())) {
            QueueConnectionFactory qcf = (QueueConnectionFactory)context.lookup(addrDetails.getJndiConnectionFactoryName());
            connection = addrDetails.isSetConnectionUserName() ? qcf.createQueueConnection(addrDetails.getConnectionUserName(), addrDetails.getConnectionPassword()) : qcf.createQueueConnection();
        } else {
            TopicConnectionFactory tcf = (TopicConnectionFactory)context.lookup(addrDetails.getJndiConnectionFactoryName());
            connection = addrDetails.isSetConnectionUserName() ? tcf.createTopicConnection(addrDetails.getConnectionUserName(), addrDetails.getConnectionPassword()) : tcf.createTopicConnection();
        }
        if (null != jmsDestConfigBean && (clientID = jmsDestConfigBean.getServerConfig().getDurableSubscriptionClientId()) != null) {
            connection.setClientID(clientID);
        }
        connection.start();
        Destination requestDestination = (Destination)context.lookup(addrDetails.getJndiDestinationName());
        Destination replyDestination = null != addrDetails.getJndiReplyDestinationName() ? (Destination)context.lookup(addrDetails.getJndiReplyDestinationName()) : null;
        JMSSessionFactory sf = new JMSSessionFactory((Connection)connection, replyDestination, context, jmsTransport, jmsDestConfigBean);
        jmsTransport.connected(requestDestination, replyDestination, sf);
    }
}

