/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.tools.common.ToolException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Stax2DOM {
    private Element currentElement;
    private Document doc;

    public Document getDocument(XMLEventReader xmlEventReader) throws ToolException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new ToolException((Throwable)e1);
        }
        this.doc = builder.newDocument();
        Element ele = this.doc.createElement("definitions");
        this.doc.appendChild(ele);
        this.currentElement = ele;
        while (xmlEventReader.hasNext()) {
            XMLEvent xmleve = (XMLEvent)xmlEventReader.next();
            if (xmleve.getEventType() == 2) {
                this.endElement();
            }
            if (xmleve.getEventType() != 1) continue;
            StartElement element = (StartElement)xmleve;
            this.startElement(element);
        }
        return this.doc;
    }

    public void startElement(StartElement ele) {
        Element element = this.doc.createElementNS(ele.getName().getNamespaceURI(), ele.getName().getLocalPart());
        Iterator<Attribute> ite = ele.getAttributes();
        while (ite.hasNext()) {
            Attribute attr = ite.next();
            element.setAttribute(attr.getName().getLocalPart(), attr.getValue());
        }
        this.currentElement.appendChild(element);
        this.currentElement = element;
        element.setUserData("location", ele.getLocation(), null);
    }

    public void endElement() {
        this.currentElement = (Element)this.currentElement.getParentNode();
    }
}

