/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.cxf.tools.validator.internal.AbstractValidator;

public class UniqueBodyPartsValidator
extends AbstractValidator {
    private Map<QName, String> uniqueBodyPartsMap;

    public UniqueBodyPartsValidator(Definition def) {
        super(def);
    }

    public boolean isValid() {
        Iterator ite = this.def.getPortTypes().values().iterator();
        while (ite.hasNext()) {
            this.uniqueBodyPartsMap = new HashMap<QName, String>();
            PortType portType = (PortType)ite.next();
            for (Operation operation : portType.getOperations()) {
                Message inMessage;
                if (operation.getInput() == null || (inMessage = operation.getInput().getMessage()) == null || this.isUniqueBodyPart(operation.getName(), inMessage)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isUniqueBodyPart(String operationName, Message msg) {
        Map partsMap = msg.getParts();
        Iterator ite = partsMap.values().iterator();
        if (ite.hasNext()) {
            Part part = (Part)ite.next();
            if (part.getElementName() == null) {
                return true;
            }
            String opName = this.getOperationNameWithSamePart(operationName, part);
            if (opName != null) {
                this.addErrorMessage("Non unique body parts, operation [ " + opName + " ] " + "and  operation [ " + operationName + " ] have the same body block " + part.getElementName());
                return false;
            }
        }
        return true;
    }

    private String getOperationNameWithSamePart(String operationName, Part part) {
        QName partQN = part.getElementName();
        String opName = this.uniqueBodyPartsMap.get(partQN);
        if (opName == null) {
            this.uniqueBodyPartsMap.put(partQN, operationName);
            return null;
        }
        return opName;
    }
}

