/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.wsdl.Definition;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.validator.internal.AbstractValidator;
import org.apache.cxf.tools.validator.internal.MIMEBindingValidator;
import org.apache.cxf.tools.validator.internal.SchemaValidator;
import org.apache.cxf.tools.validator.internal.UniqueBodyPartsValidator;
import org.apache.cxf.tools.validator.internal.WSIBPValidator;
import org.apache.cxf.tools.validator.internal.XMLFormatValidator;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL11Validator
extends AbstractValidator {
    private final List<AbstractValidator> validators = new ArrayList<AbstractValidator>();

    public WSDL11Validator(Definition definition) {
        super(definition);
    }

    public WSDL11Validator(Definition definition, ToolContext pe) {
        super(definition, pe);
    }

    @Override
    public boolean isValid() throws ToolException {
        boolean isValid = true;
        String schemaDir = this.getSchemaDir();
        SchemaValidator schemaValidator = null;
        String[] schemas = (String[])this.env.get("schemaURL");
        if (!StringUtils.isEmpty((String)schemaDir)) {
            schemaValidator = new SchemaValidator(schemaDir, (String)this.env.get("wsdlurl"), schemas);
        } else {
            try {
                schemaValidator = new SchemaValidator(this.getDefaultSchemas(), (String)this.env.get("wsdlurl"), schemas);
            }
            catch (IOException e) {
                throw new ToolException("Schemas can not be loaded before validating wsdl", (Throwable)e);
            }
        }
        if (!schemaValidator.isValid()) {
            this.addErrorMessage(schemaValidator.getErrorMessage());
            isValid = false;
            throw new ToolException(this.getErrorMessage());
        }
        this.def = schemaValidator.def;
        this.validators.add(new UniqueBodyPartsValidator(this.def));
        this.validators.add(new WSIBPValidator(this.def));
        this.validators.add(new MIMEBindingValidator(this.def));
        this.validators.add(new XMLFormatValidator(this.def));
        for (AbstractValidator validator : this.validators) {
            if (validator.isValid()) continue;
            this.addErrorMessage(validator.getErrorMessage());
            isValid = false;
            throw new ToolException(this.getErrorMessage());
        }
        return isValid;
    }

    public String getSchemaDir() {
        String dir = "";
        dir = this.env.get("schemaDir") == null ? System.getProperty("cxf_schema_dir") : (String)this.env.get("schemaDir");
        return dir;
    }

    protected List<InputSource> getDefaultSchemas() throws IOException {
        ArrayList<InputSource> xsdList = new ArrayList<InputSource>();
        ClassLoader clzLoader = Thread.currentThread().getContextClassLoader();
        URL url = clzLoader.getResource("schemas/wsdl/");
        if (url.toString().startsWith("jar")) {
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            JarFile jarFile = jarConnection.getJarFile();
            Enumeration<JarEntry> entry = jarFile.entries();
            while (entry.hasMoreElements()) {
                URIResolver resolver;
                JarEntry ele = entry.nextElement();
                if (!ele.getName().endsWith(".xsd") || ele.getName().indexOf("schemas/wsdl/") <= -1 || !(resolver = new URIResolver(ele.getName())).isResolved()) continue;
                InputSource is = new InputSource(resolver.getInputStream());
                is.setSystemId(ele.getName());
                xsdList.add(is);
            }
        } else if (url.toString().startsWith("file")) {
            URI loc = null;
            try {
                loc = url.toURI();
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            File file = new File(loc);
            if (file.exists()) {
                File[] files = file.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return pathname.getAbsolutePath().endsWith(".xsd");
                    }
                });
                for (int i = 0; i < files.length; ++i) {
                    InputSource is = new InputSource(files[i].toURL().openStream());
                    is.setSystemId(files[i].toURL().toString());
                    xsdList.add(is);
                }
            }
        }
        this.sort(xsdList);
        return xsdList;
    }

    private void sort(List<InputSource> list) {
        Collections.sort(list, new Comparator<InputSource>(){

            @Override
            public int compare(InputSource i1, InputSource i2) {
                if (i1 == null && i2 == null) {
                    return -1;
                }
                return i1.getSystemId().compareTo(i2.getSystemId());
            }
        });
    }
}

