/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.WSDLConstants;
import org.apache.cxf.tools.validator.internal.SchemaValidator;
import org.apache.cxf.tools.validator.internal.Stax2DOM;
import org.apache.cxf.tools.validator.internal.ValidatorUtil;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLElementReferenceValidator {
    private Definition def;
    private SchemaValidator schemaWSDLValidator;
    private List<XmlSchemaCollection> schemas;
    private Map<QName, QName> bindingMap = new HashMap<QName, QName>();
    private Map<QName, List> msgPartsMap = new HashMap<QName, List>();
    private Map<QName, Map> portTypes = new HashMap<QName, Map>();
    private Document document;
    private Document locationDocument;
    private boolean isValid = true;
    private XmlSchemaCollection schemaCollection = new XmlSchemaCollection();

    public WSDLElementReferenceValidator(Definition definition, SchemaValidator validator, String wsdlId, Document wsdlDocument) {
        this.def = definition;
        this.schemaWSDLValidator = validator;
        this.document = wsdlDocument;
        try {
            this.schemas = ValidatorUtil.getSchemaList(this.document, this.def.getDocumentBaseURI());
        }
        catch (IOException ex) {
            throw new ToolException("Cannot get schema list " + this.def.getDocumentBaseURI(), (Throwable)ex);
        }
        catch (SAXException ex) {
            throw new ToolException((Throwable)ex);
        }
        XMLEventReader reader = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isNamespaceAware", true);
            File file = new File(new URI(wsdlId));
            reader = factory.createXMLEventReader(new FileReader(file));
        }
        catch (XMLStreamException streamEx) {
            throw new ToolException((Throwable)streamEx);
        }
        catch (URISyntaxException e) {
            throw new ToolException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new ToolException("Cannot get the wsdl " + wsdlId, (Throwable)e);
        }
        Stax2DOM stax2dom = new Stax2DOM();
        this.locationDocument = stax2dom.getDocument(reader);
    }

    public boolean isValid() {
        this.validateMessages();
        this.validatePortType();
        this.validateBinding();
        this.validateService();
        return this.isValid;
    }

    private boolean validateMessages() {
        String tns = this.def.getTargetNamespace();
        Map messageMap = this.def.getMessages();
        Map<String, Document> wsdlImports = null;
        try {
            wsdlImports = ValidatorUtil.getImportedWsdlMap(this.document, this.def.getDocumentBaseURI());
        }
        catch (IOException ex) {
            throw new ToolException("Cannot get wsdl imports " + this.def.getDocumentBaseURI(), (Throwable)ex);
        }
        catch (SAXException ex) {
            throw new ToolException((Throwable)ex);
        }
        for (String tnsImport : wsdlImports.keySet()) {
            Document wsdlImportDoc = wsdlImports.get(tnsImport);
            NodeList nodeList = wsdlImportDoc.getElementsByTagNameNS(WSDLConstants.QNAME_MESSAGE.getNamespaceURI(), WSDLConstants.QNAME_MESSAGE.getLocalPart());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                Node attNode = node.getAttributes().getNamedItem("name");
                QName qname = new QName(tnsImport, attNode.getNodeValue());
                this.msgPartsMap.put(qname, new ArrayList());
            }
        }
        NodeList nodeList = this.document.getElementsByTagNameNS(WSDLConstants.QNAME_MESSAGE.getNamespaceURI(), WSDLConstants.QNAME_MESSAGE.getLocalPart());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Node attNode = node.getAttributes().getNamedItem("name");
            QName qname = new QName(tns, attNode.getNodeValue());
            ArrayList<String> partsList = new ArrayList<String>();
            this.msgPartsMap.put(qname, partsList);
            Message msg = (Message)messageMap.get(qname);
            Map partsMap = msg.getParts();
            for (Part part : partsMap.values()) {
                Location loc;
                boolean valid;
                Location loc2;
                QName elementName = part.getElementName();
                QName typeName = part.getTypeName();
                if (elementName == null && typeName == null) {
                    loc2 = this.getErrNodeLocation(WSDLConstants.QNAME_MESSAGE, msg.getQName().getLocalPart(), part.getName());
                    this.addError(loc2, "The part does not have a type defined. Every part must specify a type from some type system. The type can be specified using the built in 'element' or 'type' attributes or may be specified using an extension attribute.");
                    this.isValid = false;
                }
                if (elementName != null && typeName != null) {
                    loc2 = this.getErrNodeLocation(WSDLConstants.QNAME_MESSAGE, msg.getQName().getLocalPart(), part.getName());
                    this.addError(loc2, "The part has both an element and a type defined. Every part must only have an element or a type defined.");
                    this.isValid = false;
                }
                if (elementName != null && typeName == null && !(valid = this.validatePartType(elementName.getNamespaceURI(), elementName.getLocalPart(), true))) {
                    loc = this.getErrNodeLocation(WSDLConstants.QNAME_MESSAGE, msg.getQName().getLocalPart(), part.getName());
                    this.addError(loc, elementName + " cannot find reference");
                    this.isValid = false;
                }
                if (typeName != null && elementName == null && !(valid = this.validatePartType(typeName.getNamespaceURI(), typeName.getLocalPart(), false))) {
                    loc = this.getErrNodeLocation(WSDLConstants.QNAME_MESSAGE, msg.getQName().getLocalPart(), part.getName());
                    this.addError(loc, "reference cannot be found");
                    this.isValid = false;
                }
                partsList.add(part.getName());
            }
        }
        return this.isValid;
    }

    private boolean validatePartType(String namespace, String name, boolean isElement) {
        boolean partvalid = false;
        if (namespace.equals("http://www.w3.org/2001/XMLSchema")) {
            XmlSchemaType schemaType;
            XmlSchemaElement schemaEle;
            partvalid = isElement ? (schemaEle = this.schemaCollection.getElementByQName(new QName("http://www.w3.org/2001/XMLSchema", name))) != null : (schemaType = this.schemaCollection.getTypeByQName(new QName("http://www.w3.org/2001/XMLSchema", name))) != null;
        } else if (isElement) {
            for (XmlSchemaCollection schema : this.schemas) {
                if (schema == null || schema.getElementByQName(new QName(namespace, name)) == null) continue;
                partvalid = true;
                break;
            }
        } else {
            for (XmlSchemaCollection schema : this.schemas) {
                if (schema == null || schema.getTypeByQName(new QName(namespace, name)) == null) continue;
                partvalid = true;
                break;
            }
        }
        return partvalid;
    }

    private boolean validateBinding() {
        NodeList nodelist = this.document.getElementsByTagNameNS(WSDLConstants.QNAME_BINDING.getNamespaceURI(), WSDLConstants.QNAME_BINDING.getLocalPart());
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            Node n = node.getAttributes().getNamedItem("name");
            QName bindingName = new QName(this.def.getTargetNamespace(), n.getNodeValue());
            Binding binding = this.def.getBinding(bindingName);
            QName typeName = binding.getPortType().getQName();
            if (!this.portTypes.containsKey(typeName)) {
                Location loc = this.getErrNodeLocation(WSDLConstants.QNAME_DEFINITIONS, null, bindingName.getLocalPart());
                this.addError(loc, typeName + " is not defined");
                this.isValid = false;
            } else {
                Map operationMap = this.portTypes.get(typeName);
                ArrayList operationList = new ArrayList();
                operationList.addAll(operationMap.keySet());
                for (BindingOperation bop : binding.getBindingOperations()) {
                    Location loc;
                    QName bopName = new QName(this.def.getTargetNamespace(), bop.getName());
                    if (!operationList.contains(bopName)) {
                        Location loc2 = this.getErrNodeLocation(WSDLConstants.QNAME_BINDING, bindingName.getLocalPart(), bop.getName());
                        this.addError(loc2, "BindingOperation " + bop.getName() + " is not defined");
                        this.isValid = false;
                        continue;
                    }
                    Operation op = (Operation)operationMap.get(bopName);
                    if (op.getInput() == null && bop.getBindingInput() != null) {
                        loc = this.getErrNodeLocation(WSDLConstants.QNAME_BINDING, bindingName.getLocalPart(), bop.getName());
                        this.addError(loc, "BindingOperation " + bop.getName() + " binding input is not defined");
                        this.isValid = false;
                    }
                    if (op.getInput() != null && bop.getBindingInput() == null) {
                        loc = this.getErrNodeLocation(WSDLConstants.QNAME_BINDING, bindingName.getLocalPart(), bop.getName());
                        this.addError(loc, "BindingOperation " + bop.getName() + " binding input is not resolved");
                        this.isValid = false;
                    }
                    if (op.getOutput() == null && bop.getBindingOutput() != null) {
                        loc = this.getErrNodeLocation(WSDLConstants.QNAME_BINDING, bindingName.getLocalPart(), bop.getName());
                        this.addError(loc, "BindingOperation " + bop.getName() + " binding output is not defined");
                        this.isValid = false;
                    }
                    if (op.getOutput() != null && bop.getBindingOutput() == null) {
                        loc = this.getErrNodeLocation(WSDLConstants.QNAME_BINDING, bindingName.getLocalPart(), bop.getName());
                        this.addError(loc, "BindingOperation " + bop.getName() + " binding output is not resolved");
                        this.isValid = false;
                    }
                    if (op.getFaults().size() == bop.getBindingFaults().size()) continue;
                    loc = this.getErrNodeLocation(WSDLConstants.QNAME_BINDING, bindingName.getLocalPart(), bop.getName());
                    this.addError(loc, "BindingOperation " + bop.getName() + " binding fault resolved error");
                    this.isValid = false;
                }
            }
            this.bindingMap.put(bindingName, typeName);
        }
        return this.isValid;
    }

    private boolean validateService() {
        Map serviceMap = this.def.getServices();
        for (Service service : serviceMap.values()) {
            for (Port port : service.getPorts().values()) {
                Binding binding = port.getBinding();
                if (this.bindingMap.containsKey(binding.getQName())) continue;
                Location loc = this.getErrNodeLocation(WSDLConstants.QNAME_SERVICE, service.getQName().getLocalPart(), port.getName());
                this.addError(loc, " port : " + port.getName() + " reference binding is not defined");
                this.isValid = false;
            }
        }
        return this.isValid;
    }

    private boolean validatePortType() {
        String tns = this.def.getTargetNamespace();
        NodeList nodeList = this.document.getElementsByTagNameNS(WSDLConstants.QNAME_PORT_TYPE.getNamespaceURI(), WSDLConstants.QNAME_PORT_TYPE.getLocalPart());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Node attNode = node.getAttributes().getNamedItem("name");
            QName qname = new QName(tns, attNode.getNodeValue());
            Map portTypeMap = this.def.getPortTypes();
            PortType portType = (PortType)portTypeMap.get(qname);
            HashMap<QName, Operation> operationMap = new HashMap<QName, Operation>();
            this.portTypes.put(qname, operationMap);
            for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (n.getNodeType() != 1 || !n.getLocalName().equals(WSDLConstants.QNAME_OPERATION.getLocalPart())) continue;
                Node opNameNode = n.getAttributes().getNamedItem("name");
                String opName = opNameNode.getNodeValue();
                List operations = portType.getOperations();
                for (Operation operation : operations) {
                    Output output;
                    if (!operation.getName().equals(opName)) continue;
                    operationMap.put(new QName(tns, opName), operation);
                    Input input = operation.getInput();
                    if (input != null && input.getMessage() != null && !this.msgPartsMap.containsKey(input.getMessage().getQName())) {
                        Location loc = this.getErrNodeLocation(WSDLConstants.QNAME_OPERATION, operation.getName(), input.getName());
                        this.addError(loc, " input : " + input.getName() + " reference is not defined");
                        this.isValid = false;
                    }
                    if ((output = operation.getOutput()) != null && output.getMessage() != null && !this.msgPartsMap.containsKey(output.getMessage().getQName())) {
                        Location loc = this.getErrNodeLocation(WSDLConstants.QNAME_OPERATION, operation.getName(), output.getName());
                        this.addError(loc, " output : " + output.getName() + " reference is not defined");
                        this.isValid = false;
                    }
                    Map faultMap = operation.getFaults();
                    for (Fault fault : faultMap.values()) {
                        if (fault == null || fault.getMessage() == null || this.msgPartsMap.containsKey(fault.getMessage().getQName())) continue;
                        Location loc = this.getErrNodeLocation(WSDLConstants.QNAME_OPERATION, operation.getName(), fault.getName());
                        this.addError(loc, " fault : " + fault.getName() + " reference is not defined");
                        this.isValid = false;
                    }
                }
            }
        }
        return this.isValid;
    }

    private void addError(Location loc, String msg) {
        this.schemaWSDLValidator.addError(loc, msg);
    }

    public Location getErrNodeLocation(QName wsdlParentNode, String parentNameValue, String childNameValue) {
        NodeList parentNodeList = this.locationDocument.getElementsByTagNameNS(wsdlParentNode.getNamespaceURI(), wsdlParentNode.getLocalPart());
        for (int i = 0; i < parentNodeList.getLength(); ++i) {
            Node parentNode = parentNodeList.item(i);
            NamedNodeMap parentNodeMap = parentNode.getAttributes();
            Node parentAttrNode = parentNodeMap.getNamedItem("name");
            if ((parentAttrNode == null || parentNameValue == null || !parentAttrNode.getNodeValue().equals(parentNameValue)) && parentAttrNode != null && parentNameValue != null) continue;
            for (Node n = parentNode.getFirstChild(); n != null; n = n.getNextSibling()) {
                NamedNodeMap map;
                Node attrChildNode;
                if (n.getNodeType() != 1 || (attrChildNode = (map = n.getAttributes()).getNamedItem("name")) == null || !attrChildNode.getNodeValue().equals(childNameValue)) continue;
                return (Location)n.getUserData("location");
            }
        }
        return null;
    }
}

