/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.se;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.jws.WebService;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jbi.ServiceConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceClassFinder {
    private static final Logger LOG = LogUtils.getL7dLogger(WebServiceClassFinder.class);
    private final String rootPath;
    private final ClassLoader parent;

    public WebServiceClassFinder(String argRootPath, ClassLoader loader) {
        if (argRootPath.endsWith(File.separator)) {
            argRootPath = argRootPath.substring(0, argRootPath.length() - 2);
        }
        this.rootPath = argRootPath;
        this.parent = loader;
    }

    public Collection<Class<?>> findServiceConsumerClasses() throws MalformedURLException {
        return this.find(new Matcher(){

            @Override
            public boolean accept(Class<?> clz) {
                return ServiceConsumer.class.isAssignableFrom(clz) && (clz.getModifiers() & 0x400) == 0;
            }
        });
    }

    public Collection<Class<?>> findWebServiceClasses() throws MalformedURLException {
        return this.find(new Matcher(){

            @Override
            public boolean accept(Class<?> clz) {
                return clz.getAnnotation(WebService.class) != null && (clz.getModifiers() & 0x400) == 0;
            }
        });
    }

    public Collection<Class<?>> findWebServiceInterface() throws MalformedURLException {
        return this.find(new Matcher(){

            @Override
            public boolean accept(Class<?> clz) {
                return clz.getAnnotation(WebService.class) != null && (clz.getModifiers() & 0x200) == 512;
            }
        });
    }

    private Collection<Class<?>> find(Matcher matcher) throws MalformedURLException {
        ArrayList classes = new ArrayList();
        File root = new File(this.rootPath);
        URL[] urls = new URL[]{root.toURL()};
        URLClassLoader loader = new URLClassLoader(urls, this.parent);
        this.find(root, loader, classes, matcher);
        return classes;
    }

    private void find(File dir, ClassLoader loader, Collection<Class<?>> classes, Matcher matcher) {
        File[] files;
        for (File f : files = dir.listFiles()) {
            if (f.toString().endsWith(".class")) {
                Class<?> clz = this.loadClass(loader, f);
                if (!matcher.accept(clz)) continue;
                classes.add(clz);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.find(f, loader, classes, matcher);
        }
    }

    private Class<?> loadClass(ClassLoader loader, File classFile) {
        String fileName = classFile.toString();
        String className = fileName.substring(this.rootPath.length());
        if ((className = className.substring(0, className.length() - ".class".length()).replace(File.separatorChar, '.')).startsWith(".")) {
            className = className.substring(1, className.length());
        }
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            LOG.severe(new Message("FAILED.LOAD.CLASS", LOG, new Object[0]) + className);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Matcher {
        public boolean accept(Class<?> var1);
    }
}

