/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jbi.se.CXFServiceUnit;
import org.apache.cxf.jbi.se.CXFServiceUnitManager;
import org.apache.cxf.jbi.transport.JBIDestinationOutputStream;
import org.apache.cxf.jbi.transport.JBIMessageHelper;
import org.apache.cxf.jbi.transport.JBITransportFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class JBIDestination
implements Destination {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIDestination.class);
    private final DeliveryChannel channel;
    private final CXFServiceUnitManager suManager;
    private ConduitInitiator conduitInitiator;
    private EndpointInfo endpointInfo;
    private EndpointReferenceType reference;
    private MessageObserver incomingObserver;
    private JBIDispatcher dispatcher;
    private volatile boolean running;

    public JBIDestination(ConduitInitiator ci, EndpointInfo info, DeliveryChannel dc, CXFServiceUnitManager sum) {
        this.conduitInitiator = ci;
        this.endpointInfo = info;
        this.channel = dc;
        this.suManager = sum;
        this.reference = new EndpointReferenceType();
        AttributedURIType address = new AttributedURIType();
        address.setValue(this.endpointInfo.getAddress());
        this.reference.setAddress(address);
    }

    public EndpointReferenceType getAddress() {
        return this.reference;
    }

    public Conduit getBackChannel(Message inMessage, Message partialResponse, EndpointReferenceType address) throws IOException {
        BackChannelConduit backChannel = null;
        if (address == null) {
            backChannel = new BackChannelConduit(address, inMessage, this);
        } else if (partialResponse != null) {
            backChannel = new BackChannelConduit(address, inMessage, this);
        } else {
            backChannel = this.conduitInitiator.getConduit(this.endpointInfo, address);
            backChannel.setMessageObserver(new MessageObserver(){

                public void onMessage(Message m) {
                    if (m.getContentFormats().contains(InputStream.class)) {
                        InputStream is = (InputStream)m.getContent(InputStream.class);
                        try {
                            is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return backChannel;
    }

    public void shutdown() {
        this.running = false;
    }

    public void setMessageObserver(MessageObserver observer) {
        if (null != observer) {
            try {
                this.activate();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            LOG.log(Level.FINE, "JBIDestination shutdown()");
            try {
                this.deactivate();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.incomingObserver = observer;
    }

    public MessageObserver getMessageObserver() {
        return this.incomingObserver;
    }

    private void deactivate() throws IOException {
        this.running = false;
    }

    private void activate() throws IOException {
        LOG.info(new org.apache.cxf.common.i18n.Message("ACTIVE.JBI.SERVER.TRANSPORT", LOG, new Object[0]).toString());
        this.dispatcher = new JBIDispatcher();
        new Thread(this.dispatcher).start();
    }

    private void dispatch(MessageExchange exchange) throws IOException {
        QName opName = exchange.getOperation();
        LOG.fine("dispatch method: " + opName);
        NormalizedMessage nm = exchange.getMessage("in");
        try {
            InputStream in = JBIMessageHelper.convertMessageToInputStream(nm.getContent());
            MessageImpl inMessage = new MessageImpl();
            inMessage.put((Object)"cxf.jbi.message.exchange", (Object)exchange);
            inMessage.setContent(InputStream.class, (Object)in);
            inMessage.setDestination((Destination)((JBITransportFactory)this.conduitInitiator).getDestination(exchange.getService().toString() + exchange.getInterfaceName().toString()));
            ((JBITransportFactory)this.conduitInitiator).getDestination(exchange.getService().toString() + exchange.getInterfaceName().toString()).getMessageObserver().onMessage((Message)inMessage);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, new org.apache.cxf.common.i18n.Message("ERROR.PREPARE.MESSAGE", LOG, new Object[0]).toString(), ex);
            throw new IOException(ex.getMessage());
        }
    }

    private class JBIDispatcher
    implements Runnable {
        private JBIDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                JBIDestination.this.running = true;
                LOG.info(new org.apache.cxf.common.i18n.Message("RECEIVE.THREAD.START", LOG, new Object[0]).toString());
                do {
                    MessageExchange exchange = null;
                    DeliveryChannel deliveryChannel = JBIDestination.this.channel;
                    synchronized (deliveryChannel) {
                        exchange = JBIDestination.this.channel.accept();
                    }
                    if (exchange == null) continue;
                    ServiceEndpoint ep = exchange.getEndpoint();
                    CXFServiceUnit csu = JBIDestination.this.suManager.getServiceUnitForEndpoint(ep);
                    ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(csu.getClassLoader());
                        if (csu != null) {
                            LOG.info(new org.apache.cxf.common.i18n.Message("DISPATCH.TO.SU", LOG, new Object[0]).toString());
                            JBIDestination.this.dispatch(exchange);
                            continue;
                        }
                        LOG.info(new org.apache.cxf.common.i18n.Message("NO.SU.FOUND", LOG, new Object[0]).toString());
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldLoader);
                    }
                } while (JBIDestination.this.running);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, new org.apache.cxf.common.i18n.Message("ERROR.DISPATCH.THREAD", LOG, new Object[0]).toString(), ex);
            }
            LOG.fine(new org.apache.cxf.common.i18n.Message("JBI.SERVER.TRANSPORT.MESSAGE.PROCESS.THREAD.EXIT", LOG, new Object[0]).toString());
        }
    }

    protected class BackChannelConduit
    implements Conduit {
        protected Message inMessage;
        protected EndpointReferenceType target;
        protected JBIDestination jbiDestination;

        BackChannelConduit(EndpointReferenceType ref, Message message, JBIDestination dest) {
            this.inMessage = message;
            this.target = ref;
            this.jbiDestination = dest;
        }

        public void close(Message msg) throws IOException {
            ((OutputStream)msg.getContent(OutputStream.class)).close();
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void send(Message message) throws IOException {
            message.put((Object)"cxf.jbi.message.exchange", this.inMessage.get((Object)"cxf.jbi.message.exchange"));
            message.setContent(OutputStream.class, (Object)new JBIDestinationOutputStream(this.inMessage, JBIDestination.this.channel));
        }

        public EndpointReferenceType getTarget() {
            return this.target;
        }

        public Destination getBackChannel() {
            return null;
        }

        public void close() {
        }
    }
}

