/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.extensions.jaxws;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.ToolConstants;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.extensions.jaxws.BindingsNode;
import org.apache.cxf.tools.common.extensions.jaxws.JAXWSBinding;
import org.apache.cxf.tools.common.extensions.jaxws.JAXWSBindingParser;
import org.apache.cxf.tools.util.ProcessorUtil;
import org.apache.cxf.tools.util.StAXUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class CustomizationParser {
    private static final Logger LOG = LogUtils.getL7dLogger(CustomizationParser.class);
    private static CustomizationParser parser;
    private ToolContext env;
    private final Set<Element> jaxwsBindings = new HashSet<Element>();
    private Definition definition;
    private final Map<BindingsNode, JAXWSBinding> definitionExtensions = new HashMap<BindingsNode, JAXWSBinding>();
    private final Map<BindingsNode, JAXWSBinding> portTypeExtensions = new HashMap<BindingsNode, JAXWSBinding>();
    private final Map<BindingsNode, JAXWSBinding> operationExtensions = new HashMap<BindingsNode, JAXWSBinding>();
    private Element handlerChains;

    private CustomizationParser() {
    }

    public static CustomizationParser getInstance() {
        if (parser == null) {
            parser = new CustomizationParser();
        }
        return parser;
    }

    public void clean() {
        this.jaxwsBindings.clear();
        this.definitionExtensions.clear();
        this.portTypeExtensions.clear();
        this.operationExtensions.clear();
    }

    public Element getHandlerChains() {
        return this.handlerChains;
    }

    public JAXWSBinding getDefinitionExtension() {
        if (this.definitionExtensions.size() > 0) {
            return this.definitionExtensions.values().iterator().next();
        }
        return null;
    }

    public JAXWSBinding getPortTypeExtension(String portTypeName) {
        Set<BindingsNode> bindingNodes = this.portTypeExtensions.keySet();
        JAXWSBinding jaxwsBinding = null;
        for (BindingsNode bindingNode : bindingNodes) {
            if (!portTypeName.equals(bindingNode.getNodeName())) continue;
            jaxwsBinding = this.portTypeExtensions.get(bindingNode);
            break;
        }
        if (jaxwsBinding == null) {
            jaxwsBinding = this.getDefinitionExtension();
        }
        return jaxwsBinding;
    }

    public JAXWSBinding getPortTypeOperationExtension(String portTypeName, String operationName) {
        Set<BindingsNode> bindingNodes = this.operationExtensions.keySet();
        JAXWSBinding jaxwsBinding = null;
        for (BindingsNode bindingNode : bindingNodes) {
            if (!this.matchOperation(bindingNode.getXPathExpression(), portTypeName, operationName)) continue;
            jaxwsBinding = this.operationExtensions.get(bindingNode);
            break;
        }
        if (jaxwsBinding == null) {
            jaxwsBinding = this.getPortTypeExtension(portTypeName);
        }
        return jaxwsBinding;
    }

    private boolean matchOperation(String xpathExpression, String portTypeName, String operationName) {
        String regex = ".*" + this.wrapper(portTypeName) + ".*" + this.wrapper(operationName) + ".*";
        return xpathExpression.matches(regex);
    }

    public void parse(ToolContext pe, Definition def) {
        String[] bindingFiles;
        this.env = pe;
        this.definition = def;
        try {
            bindingFiles = (String[])this.env.get("binding");
        }
        catch (ClassCastException e) {
            bindingFiles = new String[]{(String)this.env.get("binding")};
        }
        for (int i = 0; i < bindingFiles.length; ++i) {
            try {
                this.addBinding(bindingFiles[i]);
                continue;
            }
            catch (XMLStreamException xse) {
                Message msg = new Message("STAX_PASER_ERROR", LOG, new Object[0]);
                throw new ToolException(msg, (Throwable)xse);
            }
        }
        for (Element jaxwsBinding : this.jaxwsBindings) {
            this.buildTargetNodeMap(jaxwsBinding, "/");
        }
        this.buildHandlerChains();
    }

    private void buildHandlerChains() {
        for (Element jaxwsBinding : this.jaxwsBindings) {
            NodeList nl = jaxwsBinding.getElementsByTagNameNS("http://java.sun.com/xml/ns/javaee", "handler-chains");
            if (nl.getLength() == 0) continue;
            this.handlerChains = (Element)nl.item(0);
            return;
        }
    }

    private void buildTargetNodeMap(Element bindings, String expression) {
        if (bindings.getAttributeNode("wsdlLocation") != null) {
            expression = "/";
        }
        if (this.isJAXWSBindings(bindings) && bindings.getAttributeNode("node") != null) {
            expression = expression + "/" + bindings.getAttribute("node");
            try {
                this.evaluateBindingsNode(bindings, expression);
            }
            catch (WSDLException we) {
                Message msg = new Message("PARSE_BININDINGFILE_EXCEPTION", LOG, new Object[0]);
                throw new ToolException(msg, (Throwable)we);
            }
        }
        Element[] children = this.getChildElements(bindings, "http://java.sun.com/xml/ns/jaxws");
        for (int i = 0; i < children.length; ++i) {
            this.buildTargetNodeMap(children[i], expression);
        }
    }

    private Element[] getChildElements(Element parent, String nsUri) {
        ArrayList<Element> a = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node item = children.item(i);
            if (!(item instanceof Element) || !nsUri.equals(item.getNamespaceURI())) continue;
            a.add((Element)item);
        }
        return a.toArray(new Element[a.size()]);
    }

    private boolean isJAXWSBindings(Node bindings) {
        return "http://java.sun.com/xml/ns/jaxws".equals(bindings.getNamespaceURI()) && "bindings".equals(bindings.getLocalName());
    }

    private void addBinding(String bindingFile) throws XMLStreamException {
        String bindingLocation = ProcessorUtil.absolutize(ProcessorUtil.getFileOrURLName(bindingFile));
        InputSource is = new InputSource(bindingLocation);
        XMLStreamReader reader = StAXUtil.createFreshXMLStreamReader(is);
        StAXUtil.toStartTag(reader);
        if (this.isValidJaxwsBindingFile(bindingFile, reader)) {
            Element root = this.parse(is);
            this.jaxwsBindings.add(root);
        } else if (this.isValidJaxbBindingFile(reader)) {
            this.env.addJaxbBindingFile(bindingFile, is);
        } else {
            Message msg = new Message("UNKONW_BINDING_FILE", LOG, new Object[]{bindingFile});
            throw new ToolException(msg);
        }
    }

    private boolean isValidJaxbBindingFile(XMLStreamReader reader) {
        return ToolConstants.JAXB_BINDINGS.equals(reader.getName());
    }

    private boolean isValidJaxwsBindingFile(String bindingLocation, XMLStreamReader reader) {
        block5: {
            try {
                if (ToolConstants.JAXWS_BINDINGS.equals(reader.getName())) {
                    String wsdlURL = (String)this.env.get("wsdlurl");
                    wsdlURL = ProcessorUtil.absolutize(ProcessorUtil.getFileOrURLName(wsdlURL));
                    String wsdlLocation = reader.getAttributeValue(null, "wsdlLocation");
                    if (StringUtils.isFileExist((String)bindingLocation) && !StringUtils.isFileAbsolute((String)wsdlLocation)) {
                        String basedir = new File(bindingLocation).getParent();
                        wsdlLocation = new File(basedir, wsdlLocation).getAbsolutePath();
                    }
                    wsdlLocation = ProcessorUtil.absolutize(ProcessorUtil.getFileOrURLName(wsdlLocation));
                    if (!StringUtils.getURL((String)wsdlURL).equals(StringUtils.getURL((String)wsdlLocation))) {
                        Message msg = new Message("NOT_POINTTO_URL", LOG, new Object[]{wsdlLocation, wsdlURL});
                        throw new ToolException(msg);
                    }
                    break block5;
                }
                return false;
            }
            catch (MalformedURLException e) {
                Message msg = new Message("CAN_NOT_GET_WSDL_LOCATION", LOG, new Object[0]);
                throw new ToolException(msg, (Throwable)e);
            }
        }
        return true;
    }

    private Element parse(InputSource source) {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setValidating(false);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                public void fatalError(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                public void warning(SAXParseException err) throws SAXParseException {
                }
            });
            return builder.parse(source).getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            throw new ToolException("parsing.parserConfigException", (Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new ToolException("parsing.factoryConfigException", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ToolException("parsing.saxException", (Throwable)e);
        }
        catch (IOException e) {
            throw new ToolException("parsing.saxException", (Throwable)e);
        }
    }

    private void evaluateBindingsNode(Element bindings, String expression) throws WSDLException {
        BindingsNode bindingsNode = this.evaluateXPathNode(expression);
        if (bindingsNode == null) {
            return;
        }
        bindingsNode.setElement(bindings);
        JAXWSBindingParser bindingsParser = new JAXWSBindingParser();
        JAXWSBinding jaxwsBinding = bindingsParser.parse(bindingsNode, this.definition);
        if (bindingsNode.getParentType().equals(Definition.class)) {
            this.definitionExtensions.put(bindingsNode, jaxwsBinding);
        }
        if (bindingsNode.getParentType().equals(PortType.class)) {
            this.portTypeExtensions.put(bindingsNode, jaxwsBinding);
        }
        if (bindingsNode.getParentType().equals(Operation.class)) {
            this.operationExtensions.put(bindingsNode, jaxwsBinding);
        }
        if (bindingsNode.getParentType().equals(BindingOperation.class)) {
            this.operationExtensions.put(bindingsNode, jaxwsBinding);
        }
    }

    private BindingsNode evaluateXPathNode(String expression) {
        String[] parts = expression.split("/");
        if (parts == null) {
            return null;
        }
        BindingsNode node = new BindingsNode();
        node.setXPathExpression(expression);
        for (int i = parts.length - 1; i > 0; --i) {
            if (parts[i].startsWith("wsdl:definitions")) {
                node.setParentType(Definition.class);
                break;
            }
            if (parts[i].startsWith("wsdl:binding")) {
                node.setParentType(Binding.class);
                node.setNodeName(this.getNodeName(parts[i]));
                break;
            }
            if (parts[i].startsWith("wsdl:portType")) {
                node.setParentType(PortType.class);
                node.setNodeName(this.getNodeName(parts[i]));
                break;
            }
            if (!parts[i].startsWith("wsdl:operation")) continue;
            if (i > 1 && parts[i - 1].startsWith("wsdl:binding")) {
                node.setParentType(BindingOperation.class);
            } else if (i > 1 && parts[i - 1].startsWith("wsdl:portType")) {
                node.setParentType(Operation.class);
            }
            node.setNodeName(this.getNodeName(parts[i]));
            break;
        }
        return node;
    }

    private String getNodeName(String expression) {
        return StringUtils.extract((String)expression, (String)"[@name='", (String)"']");
    }

    private String wrapper(String nodeName) {
        return StringUtils.wrapper((String)nodeName, (String)"[@name='", (String)"']");
    }
}

