/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.api.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.WSDLException;
import org.apache.cxf.tools.common.model.WSDLParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLModel {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLModel.class);
    protected JAXBRIContext jaxbContext;
    private Definition definition;
    private String wsdlLocation;
    private String serviceName;
    private String targetNameSpace;
    private String portTypeName;
    private String portName;
    private String packageName;
    private final List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private final Map<String, String> schemaNSFileMap = new HashMap<String, String>();
    private SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;
    private SOAPBinding.Use use = SOAPBinding.Use.LITERAL;
    private SOAPBinding.ParameterStyle paraStyle = SOAPBinding.ParameterStyle.WRAPPED;

    public WSDLModel() throws ToolException {
        try {
            WSDLFactory wsdlFactory = WSDLFactory.newInstance();
            this.definition = wsdlFactory.newDefinition();
        }
        catch (javax.wsdl.WSDLException e) {
            Message message = new Message("FAIL_TO_CREATE_WSDL_DEFINITION", LOG, new Object[0]);
            throw new ToolException(message, (Throwable)e);
        }
    }

    public void setWsdllocation(String loc) {
        this.wsdlLocation = loc;
    }

    public String getWsdllocation() {
        return this.wsdlLocation;
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String pname) {
        this.portTypeName = pname;
    }

    public void setPortName(String name) {
        this.portName = name;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setTargetNameSpace(String space) {
        this.targetNameSpace = space;
    }

    public String getTargetNameSpace() {
        return this.targetNameSpace;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String name) {
        this.packageName = name;
    }

    public void addJavaMethod(JavaMethod jmothd) {
        this.methods.add(jmothd);
    }

    public List<JavaMethod> getJavaMethods() {
        return this.methods;
    }

    public void createJAXBContext() throws ToolException {
        List<TypeReference> types = this.getAllTypeReference();
        Class[] clzzs = new Class[types.size()];
        int i = 0;
        for (TypeReference typeref : types) {
            clzzs[i++] = (Class)typeref.type;
        }
        try {
            this.jaxbContext = JAXBRIContext.newInstance((Class[])clzzs, types, (String)this.getTargetNameSpace(), (boolean)false);
        }
        catch (Exception e) {
            Message message = new Message("CREATE_JAXBRICONTEXT_EXCEPTION", LOG, new Object[0]);
            throw new ToolException(message, (Throwable)e);
        }
    }

    public List<TypeReference> getAllTypeReference() {
        ArrayList<TypeReference> types = new ArrayList<TypeReference>();
        for (JavaMethod m : this.methods) {
            WSDLParameter request = m.getRequest();
            if (request.getTypeReference() != null && m.isWrapperStyle()) {
                types.add(request.getTypeReference());
            } else {
                for (JavaParameter jp : request.getChildren()) {
                    if (jp.getTypeReference() == null) continue;
                    types.add(jp.getTypeReference());
                }
            }
            if (!m.isOneWay()) {
                WSDLParameter response = m.getResponse();
                if (response.getTypeReference() != null && m.isWrapperStyle()) {
                    types.add(response.getTypeReference());
                } else {
                    for (JavaParameter jp : response.getChildren()) {
                        if (jp.getTypeReference() == null) continue;
                        types.add(jp.getTypeReference());
                    }
                }
            }
            for (WSDLException wsdlEx : m.getWSDLExceptions()) {
                types.add(wsdlEx.getDetailTypeReference());
            }
        }
        return types;
    }

    public JAXBRIContext getJaxbContext() {
        return this.jaxbContext;
    }

    public void setStyle(SOAPBinding.Style s) {
        this.style = s;
    }

    public SOAPBinding.Style getStyle() {
        return this.style;
    }

    public void setUse(SOAPBinding.Use u) {
        this.use = u;
    }

    public SOAPBinding.ParameterStyle getParameterStyle() {
        return this.paraStyle;
    }

    public void setPrameterStyle(SOAPBinding.ParameterStyle pstyle) {
        this.paraStyle = pstyle;
    }

    public SOAPBinding.Use getUse() {
        return this.use;
    }

    public boolean isDocLit() {
        return this.style == SOAPBinding.Style.DOCUMENT && this.use == SOAPBinding.Use.LITERAL;
    }

    public boolean isWrapped() {
        return this.paraStyle == SOAPBinding.ParameterStyle.WRAPPED;
    }

    public boolean isRPC() {
        return this.style == SOAPBinding.Style.RPC && this.use == SOAPBinding.Use.LITERAL && this.paraStyle == SOAPBinding.ParameterStyle.WRAPPED;
    }

    public Map<String, String> getSchemaNSFileMap() {
        return this.schemaNSFileMap;
    }

    public void addSchemaNSFileToMap(String schemaNS, String filename) {
        this.schemaNSFileMap.put(schemaNS, filename);
    }
}

