/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class TypedStringValue {
    private String value;
    private Object targetType;

    public TypedStringValue(String value, Class targetType) {
        this.setValue(value);
        this.setTargetType(targetType);
    }

    public TypedStringValue(String value, String targetTypeName) {
        this.setValue(value);
        this.setTargetTypeName(targetTypeName);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasTargetType() {
        return this.targetType instanceof Class;
    }

    public void setTargetType(Class targetType) {
        Assert.notNull((Object)targetType, (String)"targetType is required");
        this.targetType = targetType;
    }

    public Class getTargetType() {
        if (!(this.targetType instanceof Class)) {
            throw new IllegalStateException("Typed String value does not carry a resolved target type");
        }
        return (Class)this.targetType;
    }

    public void setTargetTypeName(String targetTypeName) {
        Assert.notNull((Object)targetTypeName, (String)"targetTypeName is required");
        this.targetType = targetTypeName;
    }

    public String getTargetTypeName() {
        if (this.targetType instanceof Class) {
            return ((Class)this.targetType).getName();
        }
        return (String)this.targetType;
    }

    public Class resolveTargetType(ClassLoader classLoader) throws ClassNotFoundException {
        if (this.targetType == null) {
            return null;
        }
        Class resolvedClass = ClassUtils.forName((String)this.getTargetTypeName(), (ClassLoader)classLoader);
        this.targetType = resolvedClass;
        return resolvedClass;
    }
}

