/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.generic;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericBeanFactoryAccessor {
    private final ListableBeanFactory beanFactory;

    public GenericBeanFactoryAccessor(ListableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"'beanFactory' cannot be null.");
        this.beanFactory = beanFactory;
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        return this.getBeanFactory().getBeansOfType(type, includePrototypes, includeFactoryBeans);
    }

    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        return (T)this.getBeanFactory().getBean(name, requiredType);
    }

    public <T> T getBean(String name) throws BeansException {
        return (T)this.getBeanFactory().getBean(name);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (String beanName : this.getBeanFactory().getBeanDefinitionNames()) {
            Class beanType = this.getBeanFactory().getType(beanName);
            if (beanType.getAnnotation(annotationType) == null) continue;
            results.put(beanName, this.getBeanFactory().getBean(beanName));
        }
        return results;
    }

    public ListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }
}

