/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ResourceBundleEditor
extends PropertyEditorSupport {
    public static final String BASE_NAME_SEPARATOR = "_";

    public void setAsText(String text) throws IllegalArgumentException {
        ResourceBundle bundle;
        Assert.hasText((String)text);
        String rawBaseName = text.trim();
        int indexOfBaseNameSeparator = rawBaseName.indexOf(BASE_NAME_SEPARATOR);
        if (indexOfBaseNameSeparator == -1) {
            bundle = ResourceBundle.getBundle(rawBaseName);
        } else {
            String baseName = rawBaseName.substring(0, indexOfBaseNameSeparator);
            if (!StringUtils.hasText((String)baseName)) {
                throw new IllegalArgumentException("Bad ResourceBundle name : received '" + text + "' as argument to 'setAsText(String value)'.");
            }
            String localeString = rawBaseName.substring(indexOfBaseNameSeparator + 1);
            Locale locale = StringUtils.parseLocaleString((String)localeString);
            bundle = StringUtils.hasText((String)localeString) ? ResourceBundle.getBundle(baseName, locale) : ResourceBundle.getBundle(baseName);
        }
        this.setValue(bundle);
    }
}

