/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http;

import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.apache.cxf.binding.http.URIMapper;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String RELATIVE_PATH = "relative.path";
    private static final Logger LOG = Logger.getLogger(DispatchInterceptor.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(DispatchInterceptor.class);

    public DispatchInterceptor() {
        this.setPhase("pre-stream");
    }

    public void handleMessage(Message message) {
        String path = (String)message.get((Object)Message.PATH_INFO);
        String method = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
        String address = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo().getAddress();
        int idx = address.indexOf(47, 7);
        if (idx != -1) {
            address = address.substring(idx);
        }
        if (path.startsWith(address) && !(path = path.substring(address.length())).startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        message.put((Object)RELATIVE_PATH, (Object)path);
        LOG.info("Invoking " + method + " on " + path);
        URIMapper mapper = (URIMapper)((Service)message.getExchange().get(Service.class)).get((Object)URIMapper.class.getName());
        BindingOperationInfo op = mapper.getOperation(path, method, message);
        if (op == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OP", BUNDLE, new Object[]{method, path}));
        }
        message.getExchange().put(BindingOperationInfo.class, (Object)op);
    }
}

