/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.AbstractBindingFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.binding.http.ContentTypeOutInterceptor;
import org.apache.cxf.binding.http.DispatchInterceptor;
import org.apache.cxf.binding.http.URIParameterInterceptor;
import org.apache.cxf.binding.xml.XMLBinding;
import org.apache.cxf.binding.xml.interceptor.XMLFaultInInterceptor;
import org.apache.cxf.binding.xml.interceptor.XMLFaultOutInterceptor;
import org.apache.cxf.binding.xml.interceptor.XMLMessageOutInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.interceptor.WrappedOutInterceptor;
import org.apache.cxf.service.model.BindingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpBindingFactory
extends AbstractBindingFactory {
    public static final String HTTP_BINDING_ID = "http://apache.org/cxf/binding/http";
    private Bus bus;
    private Collection<String> activationNamespaces;

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    @Resource
    public void setActivationNamespaces(Collection<String> ans) {
        this.activationNamespaces = ans;
    }

    @PostConstruct
    void register() {
        if (null == this.bus) {
            return;
        }
        BindingFactoryManager bfm = (BindingFactoryManager)this.bus.getExtension(BindingFactoryManager.class);
        if (null != bfm) {
            for (String ns : this.activationNamespaces) {
                bfm.registerBindingFactory(ns, (BindingFactory)this);
            }
        }
    }

    public Binding createBinding(BindingInfo bi) {
        XMLBinding binding = new XMLBinding();
        binding.getInInterceptors().add(new DispatchInterceptor());
        binding.getInInterceptors().add(new URIParameterInterceptor());
        binding.getOutInterceptors().add(new StaxOutInterceptor());
        binding.getOutInterceptors().add(new ContentTypeOutInterceptor());
        binding.getOutInterceptors().add(new WrappedOutInterceptor());
        binding.getOutInterceptors().add(new XMLMessageOutInterceptor());
        binding.getInFaultInterceptors().add(new XMLFaultInInterceptor());
        binding.getOutFaultInterceptors().add(new StaxOutInterceptor());
        binding.getOutFaultInterceptors().add(new XMLFaultOutInterceptor());
        return binding;
    }
}

