/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.http.URIMapper;
import org.apache.cxf.binding.http.strategy.ConventionStrategy;
import org.apache.cxf.binding.http.strategy.JRAStrategy;
import org.apache.cxf.binding.http.strategy.ResourceStrategy;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractBindingInfoFactoryBean;
import org.apache.cxf.service.factory.MethodDispatcher;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpBindingInfoFactoryBean
extends AbstractBindingInfoFactoryBean {
    private List<ResourceStrategy> strategies = new ArrayList<ResourceStrategy>();

    public HttpBindingInfoFactoryBean() {
        this.strategies.add(new JRAStrategy());
        this.strategies.add(new ConventionStrategy());
    }

    public BindingInfo create() {
        URIMapper mapper = new URIMapper();
        BindingInfo info = new BindingInfo(this.getServiceInfo(), "http://apache.org/cxf/binding/http");
        info.setName(new QName(this.getServiceInfo().getName().getNamespaceURI(), this.getServiceInfo().getName().getLocalPart() + "HttpBinding"));
        ReflectionServiceFactoryBean sf = (ReflectionServiceFactoryBean)this.getServiceFactory();
        Service service = sf.getService();
        MethodDispatcher md = (MethodDispatcher)service.get((Object)MethodDispatcher.class.getName());
        for (OperationInfo o : this.getServiceInfo().getInterface().getOperations()) {
            BindingOperationInfo bop = info.buildOperation(o.getName(), o.getInputName(), o.getOutputName());
            info.addOperation(bop);
            Method m = md.getMethod(bop);
            for (ResourceStrategy s : this.strategies) {
                if (s.map(bop, m, mapper)) break;
            }
        }
        service.put((Object)URIMapper.class.getName(), (Object)mapper);
        return info;
    }

    public List<ResourceStrategy> getStrategies() {
        return this.strategies;
    }

    public void setStrategies(List<ResourceStrategy> strategies) {
        this.strategies = strategies;
    }
}

