/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator;

import com.sun.xml.bind.api.JAXBRIContext;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.WSDLException;
import org.apache.cxf.tools.common.model.WSDLModel;
import org.apache.cxf.tools.common.model.WSDLParameter;

public class MessagePortTypeGenerator {
    private WSDLModel wmodel;
    private Definition definition;

    public MessagePortTypeGenerator(WSDLModel model) {
        this.definition = model.getDefinition();
        this.wmodel = model;
    }

    public void generate() {
        PortType portType = this.definition.createPortType();
        portType.setQName(new QName(this.wmodel.getTargetNameSpace(), this.wmodel.getPortTypeName()));
        portType.setUndefined(false);
        for (JavaMethod method : this.wmodel.getJavaMethods()) {
            Operation operation = this.definition.createOperation();
            operation.setName(method.getName());
            operation.setUndefined(false);
            Message inputMessage = null;
            inputMessage = this.definition.createMessage();
            inputMessage.setQName(new QName(this.wmodel.getTargetNameSpace(), method.getName()));
            this.processInputMessage(operation, method, inputMessage);
            Message outputMessage = null;
            if (!method.isOneWay()) {
                outputMessage = this.definition.createMessage();
                outputMessage.setQName(new QName(this.wmodel.getTargetNameSpace(), method.getName() + "Response"));
                this.processOutputMessage(operation, method, outputMessage);
            }
            this.generateFault(method, operation);
            portType.addOperation(operation);
            this.definition.addPortType(portType);
        }
    }

    private void processInputMessage(Operation operation, JavaMethod method, Message inputMessage) {
        WSDLParameter request = method.getRequest();
        String reqNS = request.getTargetNamespace();
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT && method.isWrapperStyle()) {
            this.addPartByElementName(inputMessage, request.getName(), new QName(reqNS, request.getName()));
        }
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT && !method.isWrapperStyle()) {
            for (JavaParameter jp : request.getChildren()) {
                this.addPartByElementName(inputMessage, jp.getPartName(), new QName(jp.getTargetNamespace(), jp.getName()));
            }
        }
        if (method.getSoapStyle() == SOAPBinding.Style.RPC) {
            JAXBRIContext jxbcontext = this.wmodel.getJaxbContext();
            if (request != null && request.getChildren().size() > 0) {
                for (JavaParameter jp : request.getChildren()) {
                    QName qname = jxbcontext.getTypeName(jp.getTypeReference());
                    this.addPartByTypeName(inputMessage, jp.getPartName(), qname);
                }
            }
        }
        this.addInputToMessage(operation, inputMessage, request.getName());
        inputMessage.setUndefined(false);
        this.definition.addMessage(inputMessage);
    }

    private void processOutputMessage(Operation operation, JavaMethod method, Message outputMessage) {
        WSDLParameter response = method.getResponse();
        String resNS = response.getTargetNamespace();
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT && method.isWrapperStyle()) {
            this.addPartByElementName(outputMessage, response.getName(), new QName(resNS, response.getName()));
        }
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT && !method.isWrapperStyle()) {
            for (JavaParameter jp : response.getChildren()) {
                this.addPartByElementName(outputMessage, jp.getPartName(), new QName(jp.getTargetNamespace(), jp.getName()));
            }
        }
        if (method.getSoapStyle() == SOAPBinding.Style.RPC) {
            JAXBRIContext jxbcontext = this.wmodel.getJaxbContext();
            if (response != null && response.getChildren().size() > 0) {
                for (JavaParameter jp : response.getChildren()) {
                    QName qname = jxbcontext.getTypeName(jp.getTypeReference());
                    this.addPartByTypeName(outputMessage, jp.getPartName(), qname);
                }
            }
        }
        this.addOutputToMessage(operation, outputMessage, response.getName());
        outputMessage.setUndefined(false);
        this.definition.addMessage(outputMessage);
    }

    private void generateFault(JavaMethod method, Operation operation) {
        for (WSDLException exception : method.getWSDLExceptions()) {
            String exceptionName = exception.getExcpetionClass().getSimpleName();
            Message msg = this.definition.createMessage();
            msg.setQName(new QName(this.wmodel.getTargetNameSpace(), exceptionName));
            Part part = this.definition.createPart();
            part.setName(exception.getDetailType().getSimpleName());
            part.setElementName(exception.getDetailTypeReference().tagName);
            msg.addPart(part);
            msg.setUndefined(false);
            this.definition.addMessage(msg);
            Fault fault = this.definition.createFault();
            fault.setMessage(msg);
            fault.setName(exceptionName);
            operation.addFault(fault);
        }
    }

    private void addPartByElementName(Message message, String partName, QName partElementName) {
        if (partName == null) {
            return;
        }
        Part part = this.definition.createPart();
        part.setName(partName);
        part.setElementName(partElementName);
        message.addPart(part);
    }

    private void addPartByTypeName(Message message, String partName, QName typeName) {
        Part part = this.definition.createPart();
        part.setName(partName);
        part.setTypeName(typeName);
        message.addPart(part);
    }

    private void addInputToMessage(Operation operation, Message msg, String inputName) {
        Input input = this.definition.createInput();
        input.setMessage(msg);
        input.setName(inputName);
        operation.setInput(input);
    }

    private void addOutputToMessage(Operation operation, Message msg, String outputName) {
        Output output = this.definition.createOutput();
        output.setMessage(msg);
        output.setName(outputName);
        operation.setOutput(output);
    }
}

