/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.WSDLModel;
import org.apache.cxf.tools.java2wsdl.generator.BindingGenerator;
import org.apache.cxf.tools.java2wsdl.generator.MessagePortTypeGenerator;
import org.apache.cxf.tools.java2wsdl.generator.ServiceGenerator;
import org.apache.cxf.tools.java2wsdl.generator.TypesGenerator;
import org.apache.cxf.tools.util.SOAPBindingUtil;

public class WSDLGenerator {
    private final WSDLModel wmodel;
    private final ToolContext env;
    private final Definition definition;
    private WSDLFactory wsdlFactory;
    private String wsdlFile;
    private String portTypeName;

    public WSDLGenerator(WSDLModel model, ToolContext penv) {
        this.wmodel = model;
        this.env = penv;
        this.definition = model.getDefinition();
        try {
            this.wsdlFactory = WSDLFactory.newInstance();
        }
        catch (WSDLException e) {
            throw new ToolException(e.getMessage(), (Throwable)e);
        }
    }

    public void generate() {
        this.preGenerate();
        TypesGenerator typeGen = new TypesGenerator(this.wmodel, this.env);
        typeGen.generate();
        MessagePortTypeGenerator messagePortTypeGen = new MessagePortTypeGenerator(this.wmodel);
        messagePortTypeGen.generate();
        BindingGenerator bindingGen = new BindingGenerator(this.wmodel);
        bindingGen.generate(this.isSOAP12());
        ServiceGenerator serviceGen = new ServiceGenerator(this.wmodel);
        serviceGen.generate(this.isSOAP12());
        this.writeDefinition();
    }

    private boolean isSOAP12() {
        return this.env.optionSet("soap12");
    }

    private void preGenerate() {
        Object obj = this.env.get("outputfile");
        this.wsdlFile = obj == null ? "./" + this.wmodel.getServiceName() + ".wsdl" : (String)obj;
        obj = this.env.get("tns");
        String targetNameSpace = obj == null ? this.wmodel.getTargetNameSpace() : (String)obj;
        this.wmodel.setTargetNameSpace(targetNameSpace);
        obj = this.env.get("porttype");
        this.portTypeName = obj == null ? this.wmodel.getPortName() : (String)obj;
        this.wmodel.setPortName(this.portTypeName);
    }

    private boolean writeDefinition() {
        WSDLWriter writer = this.wsdlFactory.newWSDLWriter();
        File file = new File(this.wsdlFile);
        FileOutputStream outstream = null;
        try {
            outstream = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new ToolException(e.getMessage(), (Throwable)e);
        }
        try {
            SOAPBindingUtil.addSOAPNamespace((Definition)this.definition, (boolean)this.isSOAP12());
            writer.writeWSDL(this.definition, (OutputStream)outstream);
        }
        catch (WSDLException e) {
            throw new ToolException(e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

