/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.processor.internal;

import com.sun.xml.bind.api.TypeReference;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.jws.Oneway;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.WebFault;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.common.model.WSDLException;
import org.apache.cxf.tools.common.model.WSDLModel;
import org.apache.cxf.tools.common.model.WSDLParameter;
import org.apache.cxf.tools.util.AnnotationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPCMethodProcessor {
    private WSDLModel model;

    public RPCMethodProcessor(WSDLModel wmodel) {
        this.model = wmodel;
    }

    public void process(JavaMethod javaMethod, Method method) {
        if (this.model.getStyle() != SOAPBinding.Style.RPC) {
            this.model.setStyle(SOAPBinding.Style.RPC);
        }
        javaMethod.setSoapStyle(SOAPBinding.Style.RPC);
        javaMethod.setWrapperStyle(true);
        this.setMethodUse(javaMethod, method);
        String targetNS = this.model.getTargetNameSpace();
        WSDLParameter request = new WSDLParameter();
        request.setName(method.getName());
        request.setStyle(JavaType.Style.IN);
        request.setTargetNamespace(targetNS);
        javaMethod.addRequest(request);
        boolean isOneway = method.isAnnotationPresent(Oneway.class);
        if (!isOneway) {
            QName resQN = new QName(targetNS, method.getName() + "Response");
            TypeReference typeRef = new TypeReference(resQN, this.getClass(), new Annotation[0]);
            WSDLParameter response = new WSDLParameter();
            response.setName(method.getName() + "Response");
            response.setStyle(JavaType.Style.OUT);
            javaMethod.addResponse(response);
            Class<?> returnType = method.getReturnType();
            String resultName = method.getName() + "Response";
            String resultTNS = targetNS;
            String resultPartName = "return";
            WebResult webResult = method.getAnnotation(WebResult.class);
            boolean webResultHeader = false;
            if (webResult != null) {
                resultName = webResult.name().length() > 0 ? webResult.name() : resultName;
                resultPartName = webResult.partName().length() > 0 ? webResult.partName() : resultName;
                resultTNS = webResult.targetNamespace().length() > 0 ? webResult.targetNamespace() : resultTNS;
                webResultHeader = webResult.header();
            }
            QName resultQName = new QName(resultTNS, resultName);
            if (returnType != null && !"void".equals(returnType.getName())) {
                Annotation[] rann = new Annotation[]{};
                typeRef = new TypeReference(resultQName, returnType, rann);
                JavaParameter returnParameter = new JavaParameter(resultName, typeRef, JavaType.Style.OUT);
                returnParameter.setPartName(resultPartName);
                returnParameter.setTargetNamespace(resultTNS);
                returnParameter.setHeader(webResultHeader);
                response.addChildren(returnParameter);
            }
        }
        List<JavaParameter> paras = this.processWebPara(method);
        for (JavaParameter jp : paras) {
            request.addChildren(jp);
        }
        this.processExceptions(javaMethod, method);
    }

    private void setMethodUse(JavaMethod javaMethod, Method method) {
        SOAPBinding binding = method.getAnnotation(SOAPBinding.class);
        if (binding != null) {
            javaMethod.setSoapUse(binding.use());
        } else {
            javaMethod.setSoapUse(this.model.getUse());
        }
    }

    private List<JavaParameter> processWebPara(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] parameterGenTypes = method.getGenericParameterTypes();
        Annotation[][] paraAnns = AnnotationUtil.getPrivParameterAnnotations((Method)method);
        ArrayList<JavaParameter> paras = new ArrayList<JavaParameter>();
        int i = 0;
        for (Class clazz : parameterTypes) {
            String paraName = method.getName() + i;
            String partName = "arg" + i;
            String paraTNS = this.model.getTargetNameSpace();
            Class clazz2 = clazz;
            boolean holder = this.isHolder(clazz);
            if (holder) {
                clazz2 = this.getHoldedClass(clazz, parameterGenTypes[i]);
            }
            JavaParameter jp = null;
            for (Annotation anno : paraAnns[i]) {
                if (anno.annotationType() != WebParam.class) continue;
                WebParam webParam = (WebParam)anno;
                paraName = webParam.name().length() > 0 ? webParam.name() : paraName;
                partName = webParam.partName().length() > 0 ? webParam.partName() : paraName;
                paraTNS = webParam.targetNamespace().length() > 0 ? webParam.targetNamespace() : paraTNS;
                QName requestQN = new QName(paraTNS, paraName);
                TypeReference typeref = new TypeReference(requestQN, (Type)clazz2, paraAnns[i]);
                jp = holder ? (webParam.mode() == WebParam.Mode.INOUT ? new JavaParameter(typeref.tagName.getLocalPart(), typeref, JavaType.Style.INOUT) : new JavaParameter(typeref.tagName.getLocalPart(), typeref, JavaType.Style.OUT)) : new JavaParameter(typeref.tagName.getLocalPart(), typeref, JavaType.Style.IN);
                jp.setPartName(partName);
                jp.setHeader(webParam.header());
                jp.setTargetNamespace(paraTNS);
            }
            if (paraAnns[i].length == 0) {
                TypeReference typeref = new TypeReference(new QName(paraTNS, paraName), (Type)clazz2, paraAnns[i]);
                jp = new JavaParameter(typeref.tagName.getLocalPart(), typeref, JavaType.Style.IN);
                jp.setPartName(partName);
                jp.setTargetNamespace(paraTNS);
            }
            paras.add(jp);
            ++i;
        }
        return paras;
    }

    private void processExceptions(JavaMethod jmethod, Method method) {
        for (Type exception : method.getGenericExceptionTypes()) {
            if (RemoteException.class.isAssignableFrom((Class)exception)) continue;
            Annotation[] anns = null;
            Class exClass = (Class)exception;
            String exNameSpace = this.model.getTargetNameSpace();
            String exName = exClass.getSimpleName();
            Class<?> exReturnType = null;
            Method faultInfo = null;
            try {
                faultInfo = exClass.getMethod("getFaultInfo", new Class[0]);
            }
            catch (SecurityException e) {
                throw new ToolException(e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new ToolException(e.getMessage(), (Throwable)e);
            }
            if (faultInfo != null) {
                WebFault wf = exClass.getAnnotation(WebFault.class);
                exReturnType = faultInfo.getReturnType();
                anns = faultInfo.getAnnotations();
                if (wf.targetNamespace().length() > 0) {
                    exNameSpace = wf.targetNamespace();
                }
                exName = wf.name();
            }
            QName exQName = new QName(exNameSpace, exName);
            TypeReference tf = new TypeReference(exQName, exReturnType, anns);
            WSDLException wsdlEx = new WSDLException(exClass, tf);
            jmethod.addWSDLException(wsdlEx);
        }
    }

    private boolean isHolder(Class cType) {
        return Holder.class.isAssignableFrom(cType);
    }

    private Class getHoldedClass(Class holderClazz, Type type) {
        ParameterizedType pt = (ParameterizedType)type;
        return this.getClass(pt.getActualTypeArguments()[0]);
    }

    private Class getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)type;
            Class compType = this.getClass(gt.getGenericComponentType());
            return Array.newInstance(compType, 0).getClass();
        }
        return Object.class;
    }
}

