/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.frontend.jaxws;

import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.FrontEndGenerator;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.cxf.tools.wsdl2java.frontend.jaxws.VelocityWriter;
import org.apache.cxf.version.Version;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public abstract class AbstractGenerator
implements FrontEndGenerator {
    public static final String TEMPLATE_BASE = "org/apache/cxf/tools/wsdl2java/frontend/jaxws/template";
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractGenerator.class);
    protected ToolContext env;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected String name;

    public abstract boolean passthrough();

    public abstract void generate(ToolContext var1) throws ToolException;

    protected void doWrite(String templateName, Writer outputs) throws ToolException {
        Template tmpl = null;
        try {
            tmpl = Velocity.getTemplate((String)templateName);
        }
        catch (Exception e) {
            Message msg = new Message("TEMPLATE_MISSING", LOG, new Object[]{templateName});
            throw new ToolException(msg, (Throwable)e);
        }
        VelocityContext ctx = new VelocityContext();
        for (String key : this.attributes.keySet()) {
            ctx.put(key, this.attributes.get(key));
        }
        VelocityWriter writer = new VelocityWriter(outputs);
        try {
            tmpl.merge((Context)ctx, (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            Message msg = new Message("VELOCITY_ENGINE_WRITE_ERRORS", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)e);
        }
    }

    protected boolean isCollision(String packageName, String filename) throws ToolException {
        return this.isCollision(packageName, filename, ".java");
    }

    protected boolean isCollision(String packageName, String filename, String ext) throws ToolException {
        if (this.env.optionSet("overwrite")) {
            return false;
        }
        FileWriterUtil fw = new FileWriterUtil((String)this.env.get("outputdir"));
        return fw.isCollision(packageName, filename + ext);
    }

    protected Writer parseOutputName(String packageName, String filename, String ext) throws ToolException {
        FileWriterUtil fw = null;
        Writer writer = null;
        fw = new FileWriterUtil((String)this.env.get("outputdir"));
        try {
            writer = fw.getWriter(packageName, filename + ext);
        }
        catch (IOException ioe) {
            Message msg = new Message("FAIL_TO_WRITE_FILE", LOG, new Object[]{packageName + "." + filename + ext});
            throw new ToolException(msg, (Throwable)ioe);
        }
        return writer;
    }

    protected Writer parseOutputName(String packageName, String filename) throws ToolException {
        ClassCollector collector = (ClassCollector)this.env.get("generatedClassCollector");
        if ("sei.generator".equals(this.name)) {
            collector.addSeiClassName(packageName, filename, packageName + "." + filename);
        }
        if ("clt.generator".equals(this.name)) {
            collector.addClientClassName(packageName, filename, packageName + "." + filename);
        }
        if ("fault.generator".equals(this.name)) {
            collector.addExceptionClassName(packageName, filename, packageName + "." + filename);
        }
        if ("service.generator".equals(this.name)) {
            collector.addServiceClassName(packageName, filename, packageName + "." + filename);
        }
        if ("svr.generator".equals(this.name)) {
            collector.addServiceClassName(packageName, filename, packageName + "." + filename);
        }
        return this.parseOutputName(packageName, filename, ".java");
    }

    protected void setAttributes(String n, Object value) {
        this.attributes.put(n, value);
    }

    protected void setCommonAttributes() {
        this.attributes.put("currentdate", Calendar.getInstance().getTime());
        this.attributes.put("version", Version.getCurrentVersion());
    }

    protected void clearAttributes() {
        this.attributes.clear();
    }

    public void setEnvironment(ToolContext penv) {
        this.env = penv;
    }

    public ToolContext getEnvironment() {
        return this.env;
    }

    public String getName() {
        return this.name;
    }
}

