/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.frontend.jaxws;

import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.common.model.JavaServiceClass;
import org.apache.cxf.tools.util.ProcessorUtil;
import org.apache.cxf.tools.wsdl2java.frontend.jaxws.AbstractGenerator;

public class ServiceGenerator
extends AbstractGenerator {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractGenerator.class);
    private static final String SERVICE_TEMPLATE = "org/apache/cxf/tools/wsdl2java/frontend/jaxws/template/service.vm";

    public ServiceGenerator() {
        this.name = "service.generator";
    }

    public boolean passthrough() {
        if (this.env.optionSet("genService") || this.env.optionSet("all")) {
            return false;
        }
        return this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genSEI") || this.env.optionSet("genServer");
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = this.env.getJavaModel();
        if (this.passthrough()) {
            return;
        }
        Map serviceClasses = javaModel.getServiceClasses();
        for (JavaServiceClass js : serviceClasses.values()) {
            String location = (String)this.env.get("wsdlurl");
            URL url = null;
            try {
                url = ProcessorUtil.getWSDLURL((String)location);
            }
            catch (Exception e) {
                Message message = new Message("FAIL_TO_GET_WSDL", LOG, new Object[]{location});
                throw new ToolException(message, (Throwable)e);
            }
            this.clearAttributes();
            this.setAttributes("service", js);
            this.setAttributes("wsdlLocation", url.toString());
            this.setCommonAttributes();
            this.doWrite(SERVICE_TEMPLATE, this.parseOutputName(js.getPackageName(), js.getName()));
        }
    }
}

