/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.FrontEndGeneratorsProfile;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.extensions.jaxws.CustomizationParser;
import org.apache.cxf.tools.common.extensions.jaxws.JAXWSBinding;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.wsdl2java.frontend.jaxws.JAXWSProfile;
import org.apache.cxf.tools.wsdl2java.processor.WSDLToProcessor;
import org.apache.cxf.tools.wsdl2java.processor.compiler.Compiler;
import org.apache.cxf.tools.wsdl2java.processor.internal.PortTypeProcessor;
import org.apache.cxf.tools.wsdl2java.processor.internal.SEIAnnotationProcessor;
import org.apache.cxf.tools.wsdl2java.processor.internal.ServiceProcessor;

public class WSDLToJavaProcessor
extends WSDLToProcessor {
    public void process() throws ToolException {
        this.init();
        this.generateTypes();
        this.registerGenerators();
        this.doGeneration();
        if (this.env.get("compile") != null) {
            this.compile();
        }
        try {
            if (this.env.isExcludeNamespaceEnabled()) {
                this.removeExcludeFiles();
            }
        }
        catch (IOException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void processImportDefinition(Definition def) throws ToolException {
        this.checkSupported(def);
        this.validateWSDL(def);
        this.parseCustomization(def);
        this.env.put("generatedClassCollector", (Object)this.classColletor);
        this.registerGenerators();
        this.doGeneration();
        try {
            if (this.env.isExcludeNamespaceEnabled()) {
                this.removeExcludeFiles();
            }
        }
        catch (IOException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void removeExcludeFiles() throws IOException {
        this.excludeGenFiles = this.env.getExcludeFileList();
        if (this.excludeGenFiles == null) {
            return;
        }
        String outPutDir = (String)this.env.get("outputdir");
        for (int i = 0; i < this.excludeGenFiles.size(); ++i) {
            String excludeFile = (String)this.excludeGenFiles.get(i);
            File file = new File(outPutDir, excludeFile);
            file.delete();
            for (File tmpFile = file.getParentFile(); tmpFile != null && !tmpFile.getCanonicalPath().equalsIgnoreCase(outPutDir); tmpFile = tmpFile.getParentFile()) {
                if (!tmpFile.isDirectory() || tmpFile.list().length != 0) continue;
                tmpFile.delete();
            }
            if (this.env.get("compile") == null) continue;
            String classDir = this.env.get("classdir") == null ? outPutDir : (String)this.env.get("classdir");
            File classFile = new File(classDir, excludeFile.substring(0, excludeFile.indexOf(".java")) + ".class");
            classFile.delete();
            for (File tmpClzFile = classFile.getParentFile(); tmpClzFile != null && !tmpClzFile.getCanonicalPath().equalsIgnoreCase(outPutDir); tmpClzFile = tmpClzFile.getParentFile()) {
                if (!tmpClzFile.isDirectory() || tmpClzFile.list().length != 0) continue;
                tmpClzFile.delete();
            }
        }
    }

    private void registerGenerators() {
        String profile = null;
        if (profile == null) {
            profile = JAXWSProfile.class.getName();
        }
        FrontEndGeneratorsProfile profileObj = null;
        try {
            profileObj = (FrontEndGeneratorsProfile)Class.forName(profile).newInstance();
        }
        catch (Exception e) {
            Message msg = new Message("FAIl_TO_CREATE_PLUGINPROFILE", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        JavaModel jmodel = this.wsdlDefinitionToJavaModel(this.getWSDLDefinition());
        if (jmodel == null) {
            Message msg = new Message("FAIL_TO_CREATE_JAVA_MODEL", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        this.getEnvironment().setJavaModel(jmodel);
        this.generators = profileObj.getPlugins();
    }

    public boolean passthrough() {
        if (this.env.optionSet("genTypes") || this.env.optionSet("all")) {
            return false;
        }
        return this.env.optionSet("genAnt") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genSEI") || this.env.optionSet("genServer") || this.env.optionSet("genService");
    }

    private void generateTypes() throws ToolException {
        if (this.passthrough()) {
            return;
        }
        if (this.bindingGenerator == null) {
            return;
        }
        this.bindingGenerator.generate();
    }

    private JavaModel wsdlDefinitionToJavaModel(Definition definition) throws ToolException {
        JavaModel javaModel = new JavaModel();
        javaModel.setJAXWSBinding(this.customizing(definition));
        Map<QName, PortType> portTypes = this.getPortTypes(definition);
        Iterator<QName> iter = portTypes.keySet().iterator();
        while (iter.hasNext()) {
            PortType portType = portTypes.get(iter.next());
            PortTypeProcessor portTypeProcessor = new PortTypeProcessor(this.getEnvironment());
            portTypeProcessor.process(javaModel, portType);
        }
        ServiceProcessor serviceProcessor = new ServiceProcessor(this.env, this.getWSDLDefinition());
        serviceProcessor.process(javaModel);
        SEIAnnotationProcessor seiAnnotationProcessor = new SEIAnnotationProcessor(this.env);
        seiAnnotationProcessor.process(javaModel, definition);
        return javaModel;
    }

    private JAXWSBinding customizing(Definition def) {
        JAXWSBinding binding = CustomizationParser.getInstance().getDefinitionExtension();
        if (binding != null) {
            return binding;
        }
        List extElements = def.getExtensibilityElements();
        if (extElements.size() > 0) {
            for (Object obj : extElements) {
                if (!(obj instanceof JAXWSBinding)) continue;
                binding = (JAXWSBinding)obj;
            }
        }
        if (binding == null) {
            binding = new JAXWSBinding();
        }
        return binding;
    }

    private void compile() throws ToolException {
        boolean classpathSetted;
        ClassCollector classCollector = (ClassCollector)this.env.get("generatedClassCollector");
        ArrayList<String> argList = new ArrayList<String>();
        ArrayList<String> fileList = new ArrayList<String>();
        String javaClasspath = System.getProperty("java.class.path");
        boolean bl = classpathSetted = javaClasspath != null;
        if (this.env.isVerbose()) {
            argList.add("-verbose");
        }
        if (this.env.get("classdir") != null) {
            argList.add("-d");
            argList.add(((String)this.env.get("classdir")).replace(File.pathSeparatorChar, '/'));
        }
        if (!classpathSetted) {
            argList.add("-extdirs");
            argList.add(this.getClass().getClassLoader().getResource(".").getFile() + "../lib/");
        } else {
            argList.add("-classpath");
            argList.add(javaClasspath);
        }
        String outPutDir = (String)this.env.get("outputdir");
        HashSet<String> dirSet = new HashSet<String>();
        for (String fileName : classCollector.getGeneratedFileInfo()) {
            fileName = fileName.replace('.', File.separatorChar);
            String dirName = fileName.substring(0, fileName.lastIndexOf(File.separator) + 1);
            String path = outPutDir + File.separator + dirName;
            if (dirSet.contains(path)) continue;
            dirSet.add(path);
            File file = new File(path);
            if (!file.isDirectory()) continue;
            for (String str : file.list()) {
                if (str.endsWith("java")) {
                    fileList.add(path + str);
                    continue;
                }
                File otherFile = new File(path + File.separator + str);
                if (!otherFile.isFile() || !str.toLowerCase().endsWith("xml") || this.env.get("classdir") == null) continue;
                String targetDir = (String)this.env.get("classdir");
                File targetFile = new File(targetDir + File.separator + dirName + File.separator + str);
                this.copyXmlFile(otherFile, targetFile);
            }
        }
        String[] arguments = new String[argList.size() + fileList.size() + 1];
        arguments[0] = "javac";
        int i = 1;
        for (Object obj : argList.toArray()) {
            String arg;
            arguments[i] = arg = (String)obj;
            ++i;
        }
        int srcFileIndex = i;
        for (Object o : fileList.toArray()) {
            String file;
            arguments[i] = file = (String)o;
            ++i;
        }
        Compiler compiler = new Compiler();
        if (!compiler.internalCompile(arguments, srcFileIndex)) {
            Message msg = new Message("FAIL_TO_COMPILE_GENERATE_CODES", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    private void copyXmlFile(File from, File to) throws ToolException {
        try {
            String dir = to.getCanonicalPath().substring(0, to.getCanonicalPath().lastIndexOf(File.separator));
            File dirFile = new File(dir);
            dirFile.mkdirs();
            FileInputStream input = new FileInputStream(from);
            FileOutputStream output = new FileOutputStream(to);
            byte[] b = new byte[3072];
            int len = 0;
            while (len != -1) {
                len = input.read(b);
                if (len == -1) continue;
                output.write(b, 0, len);
            }
            output.flush();
            output.close();
            input.close();
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_COPY_GENERATED_RESOURCE_FILE", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)e);
        }
    }
}

