/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.processor.internal;

import java.util.Collection;
import java.util.Map;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Part;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaException;
import org.apache.cxf.tools.common.model.JavaExceptionClass;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.ProcessorUtil;
import org.apache.cxf.tools.wsdl2java.processor.internal.AbstractProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaultProcessor
extends AbstractProcessor {
    public FaultProcessor(ToolContext penv) {
        super(penv);
    }

    public void process(JavaMethod method, Map<String, Fault> faults) throws ToolException {
        if (faults == null) {
            return;
        }
        for (Fault fault : faults.values()) {
            this.processFault(method, fault);
        }
    }

    private boolean isNameCollision(String packageName, String className) {
        if (this.env.optionSet("overwrite")) {
            return false;
        }
        boolean collision = this.collector.containTypesClass(packageName, className) || this.collector.containSeiClass(packageName, className);
        return collision;
    }

    private void processFault(JavaMethod method, Fault fault) throws ToolException {
        JavaModel model = method.getInterface().getJavaModel();
        Message faultMessage = fault.getMessage();
        String name = ProcessorUtil.mangleNameToClassName((String)faultMessage.getQName().getLocalPart());
        String namespace = faultMessage.getQName().getNamespaceURI();
        String packageName = ProcessorUtil.parsePackageName((String)namespace, (String)this.env.mapPackageName(namespace));
        while (this.isNameCollision(packageName, name)) {
            name = name + "_Exception";
        }
        String fullClassName = packageName + "." + name;
        this.collector.addExceptionClassName(packageName, name, fullClassName);
        boolean samePackage = method.getInterface().getPackageName().equals(packageName);
        method.addException(new JavaException(name, samePackage ? name : fullClassName, namespace));
        Map faultParts = faultMessage.getParts();
        Collection faultValues = faultParts.values();
        JavaExceptionClass expClass = new JavaExceptionClass(model);
        expClass.setName(name);
        expClass.setNamespace(namespace);
        expClass.setPackageName(packageName);
        for (Part part : faultValues) {
            String fNamespace;
            String fName;
            if (part.getElementName() != null) {
                fName = part.getElementName().getLocalPart();
                fNamespace = part.getElementName().getNamespaceURI();
            } else {
                fName = part.getName();
                fNamespace = part.getTypeName().getNamespaceURI();
            }
            String fType = ProcessorUtil.getType((Part)part, (ToolContext)this.env, (boolean)false);
            String fPackageName = ProcessorUtil.parsePackageName((String)fNamespace, (String)this.env.mapPackageName(fNamespace));
            JavaField fField = new JavaField(fName, fType, fNamespace);
            fField.setQName(ProcessorUtil.getElementName((Part)part));
            if (!method.getInterface().getPackageName().equals(fPackageName)) {
                fField.setClassName(ProcessorUtil.getFullClzName((Part)part, (ToolContext)this.env, (ClassCollector)this.collector, (boolean)false));
            }
            if (!fType.equals(ProcessorUtil.resolvePartType((Part)part))) {
                fField.setClassName(ProcessorUtil.getType((Part)part, (ToolContext)this.env, (boolean)true));
            }
            expClass.addField(fField);
        }
        model.addExceptionClass(packageName + "." + name, expClass);
    }
}

