/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.processor.internal;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.ProcessorUtil;
import org.apache.cxf.tools.wsdl2java.processor.internal.NamespaceContextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAXBBindingMerger {
    protected static final Logger LOG = LogUtils.getL7dLogger(JAXBBindingMerger.class);
    private boolean merged;

    public void mergeJaxwsBinding(Element schema, ToolContext env) {
        String[] bindingFiles;
        try {
            bindingFiles = (String[])env.get("binding");
        }
        catch (ClassCastException e) {
            bindingFiles = new String[]{(String)env.get("binding")};
        }
        if (bindingFiles == null) {
            return;
        }
        for (int i = 0; i < bindingFiles.length; ++i) {
            File jaxwsFile = new File(bindingFiles[i]);
            NodeList jaxbBindingList = this.getJaxbBindingsNodes(jaxwsFile);
            String elementpath = ".";
            if (jaxbBindingList == null || jaxbBindingList.getLength() <= 0) continue;
            for (int j = 0; j < jaxbBindingList.getLength(); ++j) {
                NamespaceContextImpl nsContext;
                Node bindingNode = jaxbBindingList.item(j);
                elementpath = ((Element)bindingNode).getAttribute("node");
                NodeList bindNodesInSchemaElement = this.findBindingNode(schema, elementpath, nsContext = new NamespaceContextImpl(jaxwsFile));
                if (bindNodesInSchemaElement == null || bindNodesInSchemaElement.getLength() <= 0) continue;
                for (int k = 0; k < bindNodesInSchemaElement.getLength(); ++k) {
                    String jaxbPrefix = schema.lookupPrefix("http://java.sun.com/xml/ns/jaxb");
                    if (jaxbPrefix == null) {
                        schema.setAttribute("xmlns:jaxb", "http://java.sun.com/xml/ns/jaxb");
                        schema.setAttribute("jaxb:version", "2.0");
                    }
                    Element bindElement = (Element)bindNodesInSchemaElement.item(k);
                    NodeList jaxbBindings = bindingNode.getChildNodes();
                    if (jaxbBindings.getLength() == 0) continue;
                    Element annoElement = bindElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "annotation");
                    Element appinfoEle = bindElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", "appinfo");
                    annoElement.appendChild(appinfoEle);
                    for (int l = 0; l < jaxbBindings.getLength(); ++l) {
                        Node jaxbBindingNode = jaxbBindings.item(l);
                        Node node = ProcessorUtil.cloneNode((Document)bindElement.getOwnerDocument(), (Node)jaxbBindingNode, (boolean)true);
                        appinfoEle.appendChild(node);
                    }
                    if (bindElement.getChildNodes().getLength() > 0) {
                        bindElement.insertBefore(annoElement, bindElement.getChildNodes().item(0));
                    } else {
                        bindElement.appendChild(annoElement);
                    }
                    this.merged = true;
                }
            }
        }
    }

    private NodeList findBindingNode(Element schemaElement, String bindingPath, NamespaceContext nsContext) {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        xpath.setNamespaceContext(nsContext);
        NodeList nodelist = null;
        try {
            nodelist = (NodeList)xpath.evaluate(bindingPath, schemaElement, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return nodelist;
    }

    private NodeList getJaxbBindingsNodes(File jaxwsFile) {
        DocumentBuilderFactory docBuilderFact = DocumentBuilderFactory.newInstance();
        docBuilderFact.setNamespaceAware(true);
        NodeList nodeList = null;
        try {
            Document jaxwsDoc = docBuilderFact.newDocumentBuilder().parse(jaxwsFile);
            NodeList jaxwsBindingNodeList = jaxwsDoc.getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxws", "bindings");
            if (jaxwsBindingNodeList.getLength() == 0) {
                return null;
            }
            nodeList = jaxwsDoc.getElementsByTagNameNS("http://java.sun.com/xml/ns/jaxb", "bindings");
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_GET_JAXBINDINGNODE_FROM_JAXWSBINDING", LOG, new Object[0]);
            LOG.log(Level.SEVERE, msg.toString());
            throw new ToolException(msg, (Throwable)e);
        }
        return nodeList;
    }

    public boolean isMerged() {
        return this.merged;
    }
}

