/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.processor.internal;

import java.util.List;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaType;
import org.apache.cxf.tools.util.ProcessorUtil;
import org.apache.cxf.tools.wsdl2java.processor.internal.AbstractProcessor;

public class MIMEProcessor
extends AbstractProcessor {
    public MIMEProcessor(ToolContext penv) {
        super(penv);
    }

    private static String getJavaTypeForMimeType(MIMEPart mPart) {
        if (mPart.getExtensibilityElements().size() > 1) {
            return "javax.activation.DataHandler";
        }
        ExtensibilityElement extElement = (ExtensibilityElement)mPart.getExtensibilityElements().get(0);
        if (extElement instanceof MIMEContent) {
            MIMEContent mimeContent = (MIMEContent)extElement;
            if ("image/jpeg".equals(mimeContent.getType()) || "image/gif".equals(mimeContent.getType())) {
                return "java.awt.Image";
            }
            if ("text/xml".equals(mimeContent.getType()) || "application/xml".equals(mimeContent.getType())) {
                return "javax.xml.transform.Source";
            }
        }
        return "javax.activation.DataHandler";
    }

    public void process(JavaMethod jm, MIMEMultipartRelated ext, JavaType.Style style) throws ToolException {
        List mimeParts = ext.getMIMEParts();
        for (MIMEPart mPart : mimeParts) {
            for (ExtensibilityElement extElement : mPart.getExtensibilityElements()) {
                JavaParameter jp;
                String paramName;
                if (!(extElement instanceof MIMEContent)) continue;
                MIMEContent mimeContent = (MIMEContent)extElement;
                String mimeJavaType = MIMEProcessor.getJavaTypeForMimeType(mPart);
                if (JavaType.Style.IN.equals((Object)style)) {
                    paramName = ProcessorUtil.mangleNameToVariableName((String)mimeContent.getPart());
                    jp = jm.getParameter(paramName);
                    if (jp == null) {
                        Message message = new Message("MIMEPART_CANNOT_MAP", LOG, new Object[]{mimeContent.getPart()});
                        throw new ToolException(message);
                    }
                    if (jp.getClassName().equals(mimeJavaType)) continue;
                    jp.setClassName(mimeJavaType);
                    continue;
                }
                if (!JavaType.Style.OUT.equals((Object)style)) continue;
                if (mimeParts.size() > 2) {
                    paramName = ProcessorUtil.mangleNameToVariableName((String)mimeContent.getPart());
                    jp = jm.getParameter(paramName);
                    if (jp == null) {
                        Message message = new Message("MIMEPART_CANNOT_MAP", LOG, new Object[]{mimeContent.getPart()});
                        throw new ToolException(message);
                    }
                    if (jp.getClassName().equals(mimeJavaType)) continue;
                    jp.setClassName(mimeJavaType);
                    jp.setHolderClass(mimeJavaType);
                    continue;
                }
                if (jm.getReturn().getClassName().equals(mimeJavaType)) continue;
                jm.getReturn().setClassName(mimeJavaType);
            }
        }
    }
}

