/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdl2java.processor.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.extensions.jaxws.CustomizationParser;
import org.apache.cxf.tools.common.extensions.jaxws.JAXWSBinding;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.util.ProcessorUtil;
import org.apache.cxf.tools.wsdl2java.processor.internal.AbstractProcessor;
import org.apache.cxf.tools.wsdl2java.processor.internal.OperationProcessor;

public class PortTypeProcessor
extends AbstractProcessor {
    private List<String> operationMap = new ArrayList<String>();

    public PortTypeProcessor(ToolContext penv) {
        super(penv);
    }

    public void process(JavaModel jmodel, PortType portType) throws ToolException {
        String urlLocation;
        this.operationMap.clear();
        JavaInterface intf = new JavaInterface(jmodel);
        intf.setJAXWSBinding(this.customizing(jmodel, portType));
        intf.setHandlerChains(CustomizationParser.getInstance().getHandlerChains());
        String namespace = portType.getQName().getNamespaceURI();
        String packageName = ProcessorUtil.parsePackageName((String)namespace, (String)this.env.mapPackageName(namespace));
        String location = (String)this.env.get("wsdlurl");
        try {
            location = ProcessorUtil.getAbsolutePath((String)location);
            urlLocation = ProcessorUtil.getWSDLURL((String)location).toString();
        }
        catch (Exception ioe) {
            Message msg = new Message("CANNOT_FIND_WSDL", LOG, new Object[]{this.env.get("wsdlurl")});
            throw new ToolException(msg, (Throwable)ioe);
        }
        String serviceName = portType.getQName().getLocalPart();
        intf.setWebServiceName(serviceName);
        intf.setName(ProcessorUtil.mangleNameToClassName((String)serviceName));
        intf.setNamespace(namespace);
        intf.setPackageName(packageName);
        intf.setLocation(urlLocation);
        List operations = portType.getOperations();
        for (Operation operation : operations) {
            if (this.isOverloading(operation.getName())) {
                LOG.log(Level.WARNING, "SKIP_OVERLOADED_OPERATION", operation.getName());
                continue;
            }
            OperationProcessor operationProcessor = new OperationProcessor(this.env);
            operationProcessor.process(intf, operation);
        }
        jmodel.setLocation(urlLocation);
        jmodel.addInterface(intf.getName(), intf);
    }

    private boolean isOverloading(String operationName) {
        if (this.operationMap.contains(operationName)) {
            return true;
        }
        this.operationMap.add(operationName);
        return false;
    }

    private JAXWSBinding customizing(JavaModel jmodel, PortType portType) {
        String portTypeName = portType.getQName().getLocalPart();
        JAXWSBinding bindings = CustomizationParser.getInstance().getPortTypeExtension(portTypeName);
        if (bindings != null) {
            return bindings;
        }
        if (jmodel.getJAXWSBinding() != null) {
            return jmodel.getJAXWSBinding();
        }
        return new JAXWSBinding();
    }
}

