/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.spring.JaxbBeanDefinitionDocumentReader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class JaxbClassPathXmlApplicationContext
extends ClassPathXmlApplicationContext {
    private static final String CXF_PROPERTY_EDITORS_CFG_FILE = "META-INF/cxf/cxf-property-editors.xml";
    private static final Logger LOG = LogUtils.getL7dLogger(JaxbClassPathXmlApplicationContext.class);
    String[] cfgFileLocations;

    public JaxbClassPathXmlApplicationContext(String location) throws BeansException {
        super(new String[]{location});
    }

    public JaxbClassPathXmlApplicationContext(String[] locations) throws BeansException {
        this(locations, null);
    }

    public JaxbClassPathXmlApplicationContext(String[] locations, ApplicationContext parent) throws BeansException {
        super(locations, parent);
        this.cfgFileLocations = locations;
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
        reader.setDocumentReaderClass(JaxbBeanDefinitionDocumentReader.class);
        reader.setValidationMode(0);
        reader.setNamespaceAware(true);
    }

    protected Resource[] getConfigResources() {
        ArrayList<Object> resources = new ArrayList<Object>();
        try {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(CXF_PROPERTY_EDITORS_CFG_FILE);
            while (urls.hasMoreElements()) {
                resources.add(new UrlResource(urls.nextElement()));
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (null == this.cfgFileLocations || this.cfgFileLocations.length == 0) {
            this.cfgFileLocations = new String[1];
            this.cfgFileLocations[0] = System.getProperty("cxf.config.file");
            if (null == this.cfgFileLocations[0]) {
                this.cfgFileLocations[0] = "cxf.xml";
            }
        }
        for (String cfgFile : this.cfgFileLocations) {
            ClassPathResource cpr = new ClassPathResource(cfgFile);
            if (cpr.exists()) {
                resources.add(cpr);
                continue;
            }
            LOG.log(Level.INFO, new Message("USER_CFG_FILE_NOT_FOUND_MSG", LOG, cfgFile).toString());
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating application context with resources: " + resources);
        }
        if (0 == resources.size()) {
            return null;
        }
        Resource[] res = new Resource[resources.size()];
        res = resources.toArray(res);
        return res;
    }
}

