/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.beans.PropertyEditorSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JaxbPropertyEditor
extends PropertyEditorSupport {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxbPropertyEditor.class);
    private String packageName;

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Object getValue() {
        Object o = super.getValue();
        if (o instanceof Element) {
            Element el = (Element)o;
            try {
                return this.unmarshal(el);
            }
            catch (JAXBException ex) {
                Message msg = new Message("JAXB_PROPERTY_EDITOR_EXC", LOG, new QName(el.getNamespaceURI(), el.getLocalName()));
                throw new ConfigurationException(msg, (Throwable)ex);
            }
        }
        return o;
    }

    public String getAsText() {
        Object o = super.getValue();
        if (null == o) {
            return null;
        }
        if (o instanceof Element) {
            return ((Element)o).getTextContent();
        }
        return super.getAsText();
    }

    public void setAsText(String text) {
        Object o = super.getValue();
        if (null == o) {
            super.setValue(text);
        } else {
            super.setAsText(text);
        }
    }

    private Object unmarshal(Element data) throws JAXBException {
        return this.unmarshal(data, true);
    }

    private Object unmarshal(Element data, boolean doValidate) throws JAXBException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("unmarshalling: element namespaceURI: " + data.getNamespaceURI() + "\n" + "                       localName: " + data.getLocalName() + "\n");
        }
        JAXBContext context = null;
        Object obj = null;
        context = JAXBContext.newInstance((String)this.packageName, (ClassLoader)this.getClass().getClassLoader());
        Unmarshaller u = context.createUnmarshaller();
        obj = u.unmarshal((Node)data);
        if (obj instanceof JAXBElement) {
            JAXBElement el = (JAXBElement)obj;
            obj = el.getValue();
        }
        if (null != obj && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Unmarshaled value into object of type: " + obj.getClass().getName() + "    value: " + obj);
        }
        return obj;
    }
}

