/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.spring.JaxbPropertyEditor;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbPropertyEditorRegistrar
implements PropertyEditorRegistrar {
    private static final Logger LOG = LogUtils.getL7dLogger(JaxbPropertyEditorRegistrar.class);
    private String packageName;
    private List<String> propertyClassNames = new ArrayList<String>();

    public List<String> getPropertyClassNames() {
        return this.propertyClassNames;
    }

    public void setPropertyClassNames(List<String> propertyClassNames) {
        this.propertyClassNames = propertyClassNames;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        if (null != this.propertyClassNames && this.propertyClassNames.size() > 0) {
            JaxbPropertyEditor editor = new JaxbPropertyEditor();
            editor.setPackageName(this.packageName);
            for (String s : this.propertyClassNames) {
                String fullClassName = this.packageName + "." + s;
                Class cls = null;
                try {
                    cls = ClassLoaderUtils.loadClass(fullClassName, this.getClass());
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                }
                if (null == cls) continue;
                registry.registerCustomEditor(cls, (PropertyEditor)editor);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("registered editor for class: " + cls.getName());
            }
        }
    }
}

